/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import org.jetbrains.annotations.Nullable;

public class CraftingGridHelper
implements ICraftingGridHelper {
    @Override
    public <T> List<IRecipeSlotBuilder> createAndSetInputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs, int width, int height) {
        if (width <= 0 || height <= 0) {
            builder.setShapeless();
        }
        ArrayList<IRecipeSlotBuilder> inputSlots = new ArrayList<IRecipeSlotBuilder>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
                inputSlots.add(slot);
            }
        }
        this.setInputs(inputSlots, ingredientType, inputs, width, height);
        return inputSlots;
    }

    @Override
    public <T> void setInputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs, int width, int height) {
        this.createAndSetInputs(builder, ingredientType, inputs, width, height);
    }

    @Override
    public <T> void setInputs(List<IRecipeSlotBuilder> slotBuilders, IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs, int width, int height) {
        if (width <= 0 || height <= 0) {
            width = height = CraftingGridHelper.getShapelessSize(inputs.size());
        }
        if (slotBuilders.size() < width * height) {
            throw new IllegalArgumentException(String.format("There are not enough slots (%s) to hold a recipe of this size. (%sx%s)", slotBuilders.size(), width, height));
        }
        for (int i = 0; i < inputs.size(); ++i) {
            int index = CraftingGridHelper.getCraftingIndex(i, width, height);
            IRecipeSlotBuilder slot = slotBuilders.get(index);
            @Nullable List<@Nullable T> ingredients = inputs.get(i);
            if (ingredients == null) continue;
            slot.addIngredients(ingredientType, ingredients);
        }
    }

    @Override
    public <T> IRecipeSlotBuilder createAndSetOutputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, @Nullable @Nullable List<@Nullable T> outputs) {
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19);
        if (outputs != null) {
            outputSlot.addIngredients(ingredientType, outputs);
        }
        return outputSlot;
    }

    @Override
    public <T> void setOutputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, @Nullable @Nullable List<@Nullable T> outputs) {
        this.createAndSetOutputs(builder, ingredientType, outputs);
    }

    private static int getShapelessSize(int total) {
        if (total > 4) {
            return 3;
        }
        if (total > 1) {
            return 2;
        }
        return 1;
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }
}

