/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.runtime;

import java.util.Optional;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IJeiKeyMappings;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.ErrorUtil;

public class JeiRuntime
implements IJeiRuntime {
    private final IRecipeManager recipeManager;
    private final IIngredientListOverlay ingredientListOverlay;
    private final IBookmarkOverlay bookmarkOverlay;
    private final IRecipesGui recipesGui;
    private final IIngredientFilter ingredientFilter;
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientManager ingredientManager;
    private final IIngredientVisibility ingredientVisibility;
    private final IJeiKeyMappings keyMappings;
    private final IJeiHelpers jeiHelpers;

    public JeiRuntime(IRecipeManager recipeManager, IIngredientListOverlay ingredientListOverlay, IBookmarkOverlay bookmarkOverlay, IRecipesGui recipesGui, IIngredientFilter ingredientFilter, RegisteredIngredients registeredIngredients, IIngredientManager ingredientManager, IIngredientVisibility ingredientVisibility, IJeiKeyMappings keyMappings, IJeiHelpers jeiHelpers) {
        this.recipeManager = recipeManager;
        this.ingredientListOverlay = ingredientListOverlay;
        this.bookmarkOverlay = bookmarkOverlay;
        this.recipesGui = recipesGui;
        this.ingredientFilter = ingredientFilter;
        this.registeredIngredients = registeredIngredients;
        this.ingredientManager = ingredientManager;
        this.ingredientVisibility = ingredientVisibility;
        this.keyMappings = keyMappings;
        this.jeiHelpers = jeiHelpers;
    }

    public <T> ITypedIngredient<T> createTypedIngredient(IIngredientType<T> ingredientType, T ingredient) {
        Optional<ITypedIngredient<T>> result = TypedIngredient.createTyped(this.registeredIngredients, ingredientType, ingredient);
        if (result.isEmpty()) {
            String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient, ingredientType, this.registeredIngredients);
            throw new IllegalArgumentException("Invalid ingredient: " + ingredientInfo);
        }
        return result.get();
    }

    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public IIngredientFilter getIngredientFilter() {
        return this.ingredientFilter;
    }

    public IIngredientListOverlay getIngredientListOverlay() {
        return this.ingredientListOverlay;
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public IBookmarkOverlay getBookmarkOverlay() {
        return this.bookmarkOverlay;
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public IRecipesGui getRecipesGui() {
        return this.recipesGui;
    }

    public IIngredientVisibility getIngredientVisibility() {
        return this.ingredientVisibility;
    }

    public IJeiKeyMappings getKeyMappings() {
        return this.keyMappings;
    }
}

