/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.crafting.replacers;

import java.util.Arrays;
import java.util.List;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public final class ShulkerBoxColoringRecipeMaker {
    private static final String group = "jei.shulker.color";

    public static List<CraftingRecipe> createRecipes() {
        ItemStack baseShulkerStack = new ItemStack((ItemLike)Blocks.SHULKER_BOX);
        Ingredient baseShulkerIngredient = Ingredient.of((ItemStack[])new ItemStack[]{baseShulkerStack});
        return Arrays.stream(DyeColor.values()).map(color -> ShulkerBoxColoringRecipeMaker.createRecipe(color, baseShulkerIngredient)).toList();
    }

    private static CraftingRecipe createRecipe(DyeColor color, Ingredient baseShulkerIngredient) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        Ingredient colorIngredient = ingredientHelper.createShulkerDyeIngredient(color);
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseShulkerIngredient, colorIngredient});
        Block coloredShulkerBox = ShulkerBoxBlock.getBlockByColor((DyeColor)color);
        ItemStack output = new ItemStack((ItemLike)coloredShulkerBox);
        ResourceLocation id = new ResourceLocation("minecraft", "jei.shulker.color." + output.getDescriptionId());
        return new ShapelessRecipe(id, group, output, inputs);
    }

    private ShulkerBoxColoringRecipeMaker() {
    }
}

