/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import java.util.Optional;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.focus.FocusFactory;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.LimitedAreaInputHandler;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public class GuiAreaInputHandler
implements IUserInputHandler {
    private final FocusFactory focusFactory;
    private final GuiScreenHelper guiScreenHelper;
    private final IRecipesGui recipesGui;

    public GuiAreaInputHandler(RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper, IRecipesGui recipesGui) {
        this.focusFactory = new FocusFactory(registeredIngredients);
        this.guiScreenHelper = guiScreenHelper;
        this.recipesGui = recipesGui;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (input.is(keyBindings.getLeftClick()) && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            int guiLeft = screenHelper.getGuiLeft(guiContainer);
            int guiTop = screenHelper.getGuiTop(guiContainer);
            double guiMouseX = input.getMouseX() - (double)guiLeft;
            double guiMouseY = input.getMouseY() - (double)guiTop;
            return this.guiScreenHelper.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY).map(clickableArea -> {
                if (!input.isSimulate()) {
                    clickableArea.onClick((IFocusFactory)this.focusFactory, this.recipesGui);
                }
                ImmutableRect2i screenArea = new ImmutableRect2i(clickableArea.getArea()).addOffset(guiLeft, guiTop);
                return LimitedAreaInputHandler.create(this, screenArea);
            });
        }
        return Optional.empty();
    }
}

