/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients;

import java.util.HashSet;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;

public class IngredientBlacklistInternal {
    private final Set<String> ingredientBlacklist = new HashSet<String>();

    public <V> void addIngredientToBlacklist(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        Object ingredient = typedIngredient.getIngredient();
        String uniqueName = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        this.ingredientBlacklist.add(uniqueName);
    }

    public <V> void removeIngredientFromBlacklist(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        Object ingredient = typedIngredient.getIngredient();
        String uniqueName = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        this.ingredientBlacklist.remove(uniqueName);
    }

    public <V> boolean isIngredientBlacklistedByApi(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        String uidWild;
        Object ingredient = typedIngredient.getIngredient();
        String uid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        if (uid.equals(uidWild = ingredientHelper.getWildcardId(ingredient))) {
            return this.ingredientBlacklist.contains(uid);
        }
        return this.ingredientBlacklist.contains(uid) || this.ingredientBlacklist.contains(uidWild);
    }
}

