/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes.layout;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.gui.recipes.layout.RecipeLayout;
import mezz.jei.common.gui.recipes.layout.builder.IRecipeLayoutSlotSource;
import mezz.jei.common.gui.recipes.layout.builder.InvisibleRecipeLayoutSlotSource;
import mezz.jei.common.gui.recipes.layout.builder.RecipeSlotBuilder;
import mezz.jei.common.ingredients.IIngredientSupplier;
import mezz.jei.common.ingredients.RegisteredIngredients;

public class RecipeLayoutBuilder
implements IRecipeLayoutBuilder,
IIngredientSupplier {
    private final List<IRecipeLayoutSlotSource> slots = new ArrayList<IRecipeLayoutSlotSource>();
    private final List<List<IRecipeLayoutSlotSource>> focusLinkedSlots = new ArrayList<List<IRecipeLayoutSlotSource>>();
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientVisibility ingredientVisibility;
    private final int ingredientCycleOffset;
    private boolean shapeless = false;
    private int recipeTransferX = -1;
    private int recipeTransferY = -1;
    private int shapelessX = -1;
    private int shapelessY = -1;

    public RecipeLayoutBuilder(RegisteredIngredients registeredIngredients, IIngredientVisibility ingredientVisibility, int ingredientCycleOffset) {
        this.registeredIngredients = registeredIngredients;
        this.ingredientVisibility = ingredientVisibility;
        this.ingredientCycleOffset = ingredientCycleOffset;
    }

    public IRecipeSlotBuilder addSlot(RecipeIngredientRole role, int x, int y) {
        RecipeSlotBuilder slotBuilder = new RecipeSlotBuilder(this.registeredIngredients, role, this.ingredientVisibility, x, y, this.ingredientCycleOffset);
        this.slots.add(slotBuilder);
        return slotBuilder;
    }

    public IIngredientAcceptor<?> addInvisibleIngredients(RecipeIngredientRole role) {
        InvisibleRecipeLayoutSlotSource slot = new InvisibleRecipeLayoutSlotSource(this.registeredIngredients, role);
        this.slots.add(slot);
        return slot;
    }

    public void moveRecipeTransferButton(int posX, int posY) {
        this.recipeTransferX = posX;
        this.recipeTransferY = posY;
    }

    public void setShapeless() {
        this.shapeless = true;
    }

    public void setShapeless(int posX, int posY) {
        this.shapeless = true;
        this.shapelessX = posX;
        this.shapelessY = posY;
    }

    public void createFocusLink(IIngredientAcceptor<?> ... slots) {
        List<IRecipeLayoutSlotSource> builders = Arrays.stream(slots).map(IRecipeLayoutSlotSource.class::cast).toList();
        IntSummaryStatistics stats = builders.stream().mapToInt(IRecipeLayoutSlotSource::getIngredientCount).summaryStatistics();
        if (stats.getMin() != stats.getMax()) {
            throw new IllegalArgumentException("All slots must have the same number of ingredients in order to create a focus link. " + String.format("slot stats: %s", stats));
        }
        this.slots.removeAll(builders);
        this.focusLinkedSlots.add(builders);
    }

    public boolean isUsed() {
        return !this.slots.isEmpty() || !this.focusLinkedSlots.isEmpty();
    }

    public <R> void setRecipeLayout(RecipeLayout<R> recipeLayout, IFocusGroup focuses) {
        IntSet focusMatches;
        if (this.shapeless) {
            if (this.shapelessX >= 0 && this.shapelessY >= 0) {
                recipeLayout.setShapeless(this.shapelessX, this.shapelessY);
            } else {
                recipeLayout.setShapeless();
            }
        }
        if (this.recipeTransferX >= 0 && this.recipeTransferY >= 0) {
            recipeLayout.moveRecipeTransferButton(this.recipeTransferX, this.recipeTransferY);
        }
        for (IRecipeLayoutSlotSource iRecipeLayoutSlotSource : this.slots) {
            focusMatches = iRecipeLayoutSlotSource.getMatches(focuses);
            iRecipeLayoutSlotSource.setRecipeSlots(recipeLayout.getRecipeSlots(), focusMatches);
        }
        for (List list : this.focusLinkedSlots) {
            focusMatches = new IntArraySet();
            for (IRecipeLayoutSlotSource slot : list) {
                focusMatches.addAll((IntCollection)slot.getMatches(focuses));
            }
            for (IRecipeLayoutSlotSource slot : list) {
                slot.setRecipeSlots(recipeLayout.getRecipeSlots(), focusMatches);
            }
        }
    }

    private Stream<IRecipeLayoutSlotSource> slotStream() {
        return Stream.concat(this.slots.stream(), this.focusLinkedSlots.stream().flatMap(Collection::stream));
    }

    @Override
    public Stream<? extends IIngredientType<?>> getIngredientTypes(RecipeIngredientRole role) {
        return this.slotStream().filter(slot -> slot.getRole() == role).flatMap(IRecipeLayoutSlotSource::getIngredientTypes).distinct();
    }

    @Override
    public <T> Stream<T> getIngredientStream(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        return this.slotStream().filter(slot -> slot.getRole() == role).flatMap(slot -> slot.getIngredients(ingredientType));
    }
}

