/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.color.ColorNamer;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.ingredients.IngredientInfo;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.render.IngredientRenderHelper;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.search.SearchMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class IngredientGridTooltipHelper {
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IWorldConfig worldConfig;
    private final IModIdHelper modIdHelper;
    private final IInternalKeyMappings keyBindings;

    public IngredientGridTooltipHelper(RegisteredIngredients registeredIngredients, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, IModIdHelper modIdHelper, IInternalKeyMappings keyBindings) {
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.worldConfig = worldConfig;
        this.modIdHelper = modIdHelper;
        this.keyBindings = keyBindings;
    }

    public <T> void drawTooltip(PoseStack poseStack, int mouseX, int mouseY, ITypedIngredient<T> value) {
        IIngredientType ingredientType = value.getType();
        Object ingredient = value.getIngredient();
        IngredientInfo ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        IIngredientRenderer ingredientRenderer = ingredientInfo.getIngredientRenderer();
        List<Component> tooltip = this.getTooltip(ingredient, ingredientInfo);
        TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, ingredient, ingredientRenderer);
    }

    public <T> List<Component> getTooltip(T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
        List<Component> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, ingredientRenderer, ingredientHelper, this.modIdHelper);
        ArrayList<Component> tooltip = new ArrayList<Component>(ingredientTooltipSafe);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            IngredientGridTooltipHelper.addColorSearchInfoToTooltip(tooltip, ingredient, ingredientInfo);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
        return tooltip;
    }

    private static <T> void addColorSearchInfoToTooltip(List<Component> tooltip, T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientHelper<T> ingredientHelper;
        Iterable colors;
        ColorNamer colorNamer = ColorNamer.getInstance();
        String colorNamesString = colorNamer.getColorNames(colors = (ingredientHelper = ingredientInfo.getIngredientHelper()).getColors(ingredient)).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            MutableComponent colorTranslation = Component.translatable((String)"jei.tooltip.item.colors", (Object[])new Object[]{colorNamesString}).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(List<Component> tooltip, IInternalKeyMappings keyBindings) {
        List<MutableComponent> lines = List.of(CommonComponents.EMPTY, Component.translatable((String)"gui.jei.editMode.description").withStyle(ChatFormatting.DARK_GREEN), Component.translatable((String)"gui.jei.editMode.description.hide", (Object[])new Object[]{keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"gui.jei.editMode.description.hide.wild", (Object[])new Object[]{keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY));
        tooltip.addAll(lines);
    }
}

