/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.focus;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.util.ErrorUtil;

public final class Focus<V>
implements IFocus<V>,
IFocusGroup {
    private final RecipeIngredientRole role;
    private final ITypedIngredient<V> value;

    public Focus(RecipeIngredientRole role, ITypedIngredient<V> value) {
        ErrorUtil.checkNotNull(role, "focus role");
        ErrorUtil.checkNotNull(value, "focus value");
        this.role = role;
        this.value = value;
    }

    public ITypedIngredient<V> getTypedValue() {
        return this.value;
    }

    public RecipeIngredientRole getRole() {
        return this.role;
    }

    public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
        if (this.value.getType() == ingredientType) {
            Focus cast = this;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    public static <V> Focus<V> checkOne(IFocus<V> focus, RegisteredIngredients registeredIngredients) {
        if (focus instanceof Focus) {
            return (Focus)focus;
        }
        ErrorUtil.checkNotNull(focus, "focus");
        ITypedIngredient value = focus.getTypedValue();
        ErrorUtil.checkNotNull(value, "focus typed value");
        IIngredientType type = value.getType();
        ErrorUtil.checkNotNull(type, "focus type");
        Object ingredient = value.getIngredient();
        ErrorUtil.checkNotNull(type, "focus ingredient");
        RecipeIngredientRole role = focus.getRole();
        ErrorUtil.checkNotNull(role, "focus typed value role");
        return Focus.createFromApi(registeredIngredients, role, type, ingredient);
    }

    public static <V> Focus<V> createFromApi(RegisteredIngredients registeredIngredients, RecipeIngredientRole role, IIngredientType<V> ingredientType, V value) {
        Optional typedIngredient = TypedIngredient.createTyped(registeredIngredients, ingredientType, value).flatMap(i -> TypedIngredient.deepCopy(registeredIngredients, i));
        if (typedIngredient.isEmpty()) {
            throw new IllegalArgumentException("Focus value is invalid: " + ErrorUtil.getIngredientInfo(value, ingredientType, registeredIngredients));
        }
        return new Focus<V>(role, (ITypedIngredient)typedIngredient.get());
    }

    public boolean isEmpty() {
        return false;
    }

    public List<IFocus<?>> getAllFocuses() {
        return List.of(this);
    }

    public Stream<IFocus<?>> getFocuses(RecipeIngredientRole role) {
        if (role == this.role) {
            return Stream.of(this);
        }
        return Stream.empty();
    }

    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType) {
        return this.checkedCast(ingredientType).stream();
    }

    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        if (role == this.role) {
            return this.getFocuses(ingredientType);
        }
        return Stream.empty();
    }
}

