/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.core.config.IWorldConfig;

public class WorldConfig
implements IWorldConfig {
    private final IConnectionToServer serverConnection;
    private final IInternalKeyMappings keyBindings;
    private boolean overlayEnabled = true;
    private boolean cheatItemsEnabled = false;
    private boolean editModeEnabled = false;
    private boolean bookmarkOverlayEnabled = true;

    public WorldConfig(IConnectionToServer serverConnection, IInternalKeyMappings keyBindings) {
        this.serverConnection = serverConnection;
        this.keyBindings = keyBindings;
    }

    public boolean isOverlayEnabled() {
        if (this.overlayEnabled) {
            return true;
        }
        return this.keyBindings.getToggleOverlay().isUnbound();
    }

    public void toggleOverlayEnabled() {
        this.overlayEnabled = !this.overlayEnabled;
    }

    public boolean isBookmarkOverlayEnabled() {
        return this.isOverlayEnabled() && this.bookmarkOverlayEnabled;
    }

    public void toggleBookmarkEnabled() {
        this.setBookmarkEnabled(!this.bookmarkOverlayEnabled);
    }

    public void setBookmarkEnabled(boolean value) {
        if (this.bookmarkOverlayEnabled != value) {
            this.bookmarkOverlayEnabled = value;
        }
    }

    public boolean isCheatItemsEnabled() {
        return this.cheatItemsEnabled;
    }

    public boolean isDeleteItemsInCheatModeActive() {
        return this.cheatItemsEnabled && this.serverConnection.isJeiOnServer();
    }

    public void toggleCheatItemsEnabled() {
        this.setCheatItemsEnabled(!this.cheatItemsEnabled);
    }

    public void setCheatItemsEnabled(boolean value) {
        if (this.cheatItemsEnabled != value) {
            this.cheatItemsEnabled = value;
            if (this.cheatItemsEnabled && this.serverConnection.isJeiOnServer()) {
                this.serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    public boolean isEditModeEnabled() {
        return this.editModeEnabled;
    }

    public void toggleEditModeEnabled() {
        this.editModeEnabled = !this.editModeEnabled;
    }
}

