/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.recipes.layout.IRecipeLayoutInternal;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.ItemStackMatchable;
import mezz.jei.common.util.MatchingIterable;
import mezz.jei.common.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    @Nullable
    public static IRecipeTransferError getTransferRecipeError(RecipeTransferManager recipeTransferManager, AbstractContainerMenu container, IRecipeLayoutInternal<?> recipeLayout, Player player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(RecipeTransferManager recipeTransferManager, AbstractContainerMenu container, IRecipeLayoutInternal<?> recipeLayout, Player player, boolean maxTransfer) {
        IRecipeTransferError error = RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true);
        return RecipeTransferUtil.allowsTransfer(error);
    }

    @Nullable
    private static <C extends AbstractContainerMenu, R> IRecipeTransferError transferRecipe(RecipeTransferManager recipeTransferManager, C container, IRecipeLayoutInternal<R> recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (Internal.getRuntime().isEmpty()) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        IRecipeTransferHandler<C, R> transferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeCategory);
        if (transferHandler == null) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return RecipeTransferErrorInternal.INSTANCE;
        }
        RecipeSlots recipeSlots = recipeLayout.getRecipeSlots();
        IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
        try {
            return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeSlotsView, player, maxTransfer, doTransfer);
        }
        catch (RuntimeException e) {
            LOGGER.error("Recipe transfer handler '{}' for container '{}' and recipe type '{}' threw an error: ", transferHandler.getClass(), (Object)transferHandler.getContainerClass(), (Object)recipeCategory.getRecipeType().getUid(), (Object)e);
            return RecipeTransferErrorInternal.INSTANCE;
        }
    }

    public static boolean allowsTransfer(@Nullable IRecipeTransferError error) {
        return error == null || error.getType() == IRecipeTransferError.Type.COSMETIC;
    }

    public static boolean validateSlots(Player player, Collection<TransferOperation> transferOperations, Collection<Slot> craftingSlots, Collection<Slot> inventorySlots) {
        Set<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.index).collect(Collectors.toSet());
        Set<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.index).collect(Collectors.toSet());
        List<Integer> invalidRecipeIndexes = transferOperations.stream().map(TransferOperation::craftingSlot).map(s -> s.index).filter(s -> !craftingSlotIndexes.contains(s)).toList();
        if (!invalidRecipeIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots for the destination of the recipe, the slots are not included in the list of crafting slots. " + StringUtil.intsToString(invalidRecipeIndexes));
            return false;
        }
        List<Integer> invalidInventorySlotIndexes = transferOperations.stream().map(TransferOperation::inventorySlot).map(s -> s.index).filter(s -> !inventorySlotIndexes.contains(s) && !craftingSlotIndexes.contains(s)).toList();
        if (!invalidInventorySlotIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid source slots for the inventory stacks for the recipe, the slots are not included in the list of inventory slots or recipe slots. " + StringUtil.intsToString(invalidInventorySlotIndexes) + "\n inventory slots: " + StringUtil.intsToString(inventorySlotIndexes) + "\n crafting slots: " + StringUtil.intsToString(craftingSlotIndexes));
            return false;
        }
        Set<Integer> overlappingSlots = inventorySlotIndexes.stream().filter(craftingSlotIndexes::contains).collect(Collectors.toSet());
        if (!overlappingSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, inventorySlots and craftingSlots should not share any slot, but both have: " + StringUtil.intsToString(overlappingSlots));
            return false;
        }
        List<Integer> invalidPickupSlots = Stream.concat(craftingSlots.stream(), inventorySlots.stream()).filter(Slot::hasItem).filter(slot -> !slot.mayPickup(player)).map(slot -> slot.index).toList();
        if (!invalidPickupSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, the player is unable to pickup from them: " + StringUtil.intsToString(invalidPickupSlots));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static RecipeTransferOperationsResult getRecipeTransferOperations(final IStackHelper stackhelper, Map<Slot, ItemStack> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, List<Slot> craftingSlots) {
        void var7_11;
        RecipeTransferOperationsResult transferOperations = new RecipeTransferOperationsResult();
        IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
        for (Map.Entry<Slot, ItemStack> entry : availableItemStacks.entrySet()) {
            for (IRecipeSlotView ingredient : requiredItemStacks) {
                if (ingredient.isEmpty() || !ingredient.getItemStacks().anyMatch(it -> stackhelper.isEquivalent(it, (ItemStack)slotTuple.getValue(), UidContext.Ingredient))) continue;
                relevantSlots.computeIfAbsent(ingredient, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                    public int hashCode(ItemStack o) {
                        return o.getItem().hashCode();
                    }

                    public boolean equals(ItemStack a, ItemStack b) {
                        return stackhelper.isEquivalent(a, b, UidContext.Ingredient);
                    }
                })).computeIfAbsent(entry.getValue(), it -> new ArrayList()).add(new PhantomSlotState(entry.getKey(), entry.getValue()));
            }
        }
        Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
        for (Map.Entry entry : relevantSlots.entrySet()) {
            ArrayList<PhantomSlotStateList> countedAndSorted = new ArrayList<PhantomSlotStateList>();
            for (Map.Entry foundSlots : ((Map)entry.getValue()).entrySet()) {
                ((ArrayList)foundSlots.getValue()).sort((o1, o2) -> {
                    int compare = Integer.compare(o1.itemStack.getCount(), o2.itemStack.getCount());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.index, o2.slot.index);
                    }
                    return compare;
                });
                countedAndSorted.add(new PhantomSlotStateList((List)foundSlots.getValue()));
            }
            countedAndSorted.sort((o1, o2) -> {
                int compare = Long.compare(o2.totalItemCount, o1.totalItemCount);
                if (compare == 0) {
                    return Integer.compare(o1.stateList.stream().mapToInt(it -> it.slot.index).min().orElse(0), o2.stateList.stream().mapToInt(it -> it.slot.index).min().orElse(0));
                }
                return compare;
            });
            bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
        }
        for (IRecipeSlotView iRecipeSlotView : requiredItemStacks) {
            if (iRecipeSlotView.isEmpty()) continue;
            bestMatches.computeIfAbsent(iRecipeSlotView, it -> new ArrayList());
        }
        boolean bl = false;
        while (var7_11 < requiredItemStacks.size()) {
            IRecipeSlotView iRecipeSlotView = requiredItemStacks.get((int)var7_11);
            if (!iRecipeSlotView.isEmpty()) {
                Slot craftingSlot = craftingSlots.get((int)var7_11);
                PhantomSlotState matching = ((ArrayList)bestMatches.get(iRecipeSlotView)).stream().flatMap(PhantomSlotStateList::stream).findFirst().orElse(null);
                if (matching == null) {
                    transferOperations.missingItems.add(iRecipeSlotView);
                } else {
                    Slot matchingSlot = matching.slot;
                    ItemStack matchingStack = matching.itemStack;
                    matchingStack.shrink(1);
                    transferOperations.results.add(new TransferOperation(matchingSlot, craftingSlot));
                }
            }
            ++var7_11;
        }
        return transferOperations;
    }

    @Nullable
    public static <T> Map.Entry<T, ItemStack> containsAnyStackIndexed(IStackHelper stackhelper, Map<T, ItemStack> stacks, IRecipeSlotView recipeSlotView) {
        MatchingIndexed<T> matchingStacks = new MatchingIndexed<T>(stacks);
        List<ItemStack> ingredients = recipeSlotView.getItemStacks().toList();
        MatchingIterable matchingContains = new MatchingIterable(ingredients);
        return (Map.Entry)RecipeTransferUtil.containsStackMatchable(stackhelper, matchingStacks, matchingContains);
    }

    @Nullable
    public static <R, T> R containsStackMatchable(IStackHelper stackhelper, Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = RecipeTransferUtil.containsStack(stackhelper, stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public static <R> R containsStack(IStackHelper stackHelper, Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!stackHelper.isEquivalent(contains.getStack(), stack.getStack(), UidContext.Recipe)) continue;
            return stack.getResult();
        }
        return null;
    }

    private record PhantomSlotState(Slot slot, ItemStack itemStack) {
    }

    private record PhantomSlotStateList(List<PhantomSlotState> stateList, long totalItemCount) {
        public PhantomSlotStateList(List<PhantomSlotState> states) {
            this(states, states.stream().mapToLong(it -> it.itemStack.getCount()).sum());
        }

        public Stream<PhantomSlotState> stream() {
            return this.stateList.stream().filter(it -> !it.itemStack.isEmpty());
        }
    }

    private static class MatchingIndexed<T>
    implements Iterable<ItemStackMatchable<Map.Entry<T, ItemStack>>> {
        private final Map<T, ItemStack> map;

        public MatchingIndexed(Map<T, ItemStack> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Map.Entry<T, ItemStack>>> iterator() {
            return new MatchingIterable.DelegateIterator<Map.Entry<T, ItemStack>, ItemStackMatchable<Map.Entry<T, ItemStack>>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Map.Entry<T, ItemStack>> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Map.Entry<T, ItemStack>>(){

                        @Override
                        public ItemStack getStack() {
                            return (ItemStack)entry.getValue();
                        }

                        @Override
                        public Map.Entry<T, ItemStack> getResult() {
                            return entry;
                        }
                    };
                }
            };
        }
    }
}

