/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients.fluid;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.TagUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientHelper<T>
implements IIngredientHelper<T> {
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;
    private final IPlatformFluidHelperInternal<T> platformFluidHelper;
    private final IPlatformRegistry<Fluid> registry;
    private final IIngredientTypeWithSubtypes<Fluid, T> fluidType;

    public FluidIngredientHelper(ISubtypeManager subtypeManager, IColorHelper colorHelper, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
        this.platformFluidHelper = platformFluidHelper;
        this.registry = Services.PLATFORM.getRegistry(Registry.FLUID_REGISTRY);
        this.fluidType = platformFluidHelper.getFluidIngredientType();
    }

    public IIngredientType<T> getIngredientType() {
        return this.platformFluidHelper.getFluidIngredientType();
    }

    public String getDisplayName(T ingredient) {
        Component displayName = this.platformFluidHelper.getDisplayName(ingredient);
        return displayName.getString();
    }

    public String getUniqueId(T ingredient, UidContext context) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.registry.getRegistryName(fluid);
        StringBuilder result = new StringBuilder().append("fluid:").append(registryName);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(this.fluidType, ingredient, context);
        if (!subtypeInfo.isEmpty()) {
            result.append(":");
            result.append(subtypeInfo);
        }
        return result.toString();
    }

    public String getWildcardId(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.registry.getRegistryName(fluid);
        return "fluid:" + registryName;
    }

    public Iterable<Integer> getColors(T ingredient) {
        TextureAtlasSprite fluidStillSprite = this.platformFluidHelper.getStillFluidSprite(ingredient);
        if (fluidStillSprite == null) {
            return List.of();
        }
        int renderColor = this.platformFluidHelper.getColorTint(ingredient);
        return this.colorHelper.getColors(fluidStillSprite, renderColor, 1);
    }

    public ResourceLocation getResourceLocation(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.registry.getRegistryName(fluid);
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registry name for: " + ingredientInfo);
        }
        return registryName;
    }

    public ItemStack getCheatItemStack(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        Item filledBucket = fluid.getBucket();
        return new ItemStack((ItemLike)filledBucket);
    }

    public T copyIngredient(T ingredient) {
        return this.platformFluidHelper.copy(ingredient);
    }

    public T normalizeIngredient(T ingredient) {
        return this.platformFluidHelper.normalize(ingredient);
    }

    public Collection<ResourceLocation> getTags(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        Stream tagKeyStream = Registry.FLUID.getResourceKey((Object)fluid).flatMap(arg_0 -> ((DefaultedRegistry)Registry.FLUID).getHolder(arg_0)).map(Holder::tags).orElse(Stream.of(new TagKey[0]));
        return TagUtil.getTags(tagKeyStream);
    }

    public String getErrorInfo(@Nullable T ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        if (fluid != null) {
            Component displayName = this.platformFluidHelper.getDisplayName(ingredient);
            toStringHelper.add("Fluid", (Object)displayName.getString());
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", this.platformFluidHelper.getAmount(ingredient));
        this.platformFluidHelper.getTag(ingredient).ifPresent(tag -> toStringHelper.add("Tag", tag));
        return toStringHelper.toString();
    }

    public Optional<ResourceLocation> getTagEquivalent(Collection<T> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, arg_0 -> this.fluidType.getBase(arg_0), () -> ((DefaultedRegistry)Registry.FLUID).getTags());
    }
}

