/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import java.util.Optional;
import mezz.jei.common.bookmarks.BookmarkList;
import mezz.jei.common.input.CombinedRecipeFocusSource;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.LimitedAreaInputHandler;
import net.minecraft.client.gui.screens.Screen;

public class BookmarkInputHandler
implements IUserInputHandler {
    private final CombinedRecipeFocusSource focusSource;
    private final BookmarkList bookmarkList;

    public BookmarkInputHandler(CombinedRecipeFocusSource focusSource, BookmarkList bookmarkList) {
        this.focusSource = focusSource;
        this.bookmarkList = bookmarkList;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (input.is(keyBindings.getBookmark())) {
            return this.handleBookmark(input, keyBindings);
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handleBookmark(UserInput input, IInternalKeyMappings keyBindings) {
        return this.focusSource.getIngredientUnderMouse(input, keyBindings).findFirst().flatMap(clicked -> {
            if (input.isSimulate() || this.bookmarkList.remove(clicked.getTypedIngredient()) || this.bookmarkList.add(clicked.getTypedIngredient())) {
                return Optional.of(LimitedAreaInputHandler.create(this, clicked.getArea()));
            }
            return Optional.empty();
        });
    }
}

