/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file.serializers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.config.file.serializers.DeserializeResult;
import mezz.jei.common.config.file.serializers.IConfigValueSerializer;
import net.minecraft.ChatFormatting;

public class ChatFormattingSerializer
implements IConfigValueSerializer<List<ChatFormatting>> {
    public static final ChatFormattingSerializer INSTANCE = new ChatFormattingSerializer();

    private ChatFormattingSerializer() {
    }

    @Override
    public String serialize(List<ChatFormatting> value) {
        return value.stream().map(ChatFormatting::m_126666_).collect(Collectors.joining(" "));
    }

    @Override
    public DeserializeResult<List<ChatFormatting>> deserialize(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.isEmpty()) {
            return new DeserializeResult<List<ChatFormatting>>(List.of());
        }
        ArrayList<String> errors = new ArrayList<String>();
        String[] strings = string.split(" ");
        List result = Arrays.stream(strings).mapMulti((s, c) -> {
            ChatFormatting chatFormatting = ChatFormatting.m_126657_((String)s);
            if (chatFormatting != null) {
                c.accept(chatFormatting);
            } else {
                errors.add("No Chat Formatting found for name: '%s'".formatted(s));
            }
        }).toList();
        return new DeserializeResult<List<ChatFormatting>>(result, errors);
    }

    @Override
    public String getValidValuesDescription() {
        EnumSet<ChatFormatting> validFormatting = EnumSet.allOf(ChatFormatting.class);
        validFormatting.remove(ChatFormatting.RESET);
        ArrayList<ChatFormatting> validColors = new ArrayList<ChatFormatting>();
        ArrayList<ChatFormatting> validFormats = new ArrayList<ChatFormatting>();
        for (ChatFormatting chatFormatting : validFormatting) {
            if (chatFormatting.m_126664_()) {
                validColors.add(chatFormatting);
                continue;
            }
            if (!chatFormatting.m_126661_()) continue;
            validFormats.add(chatFormatting);
        }
        return "A chat formatting string.\nUse these formatting colors:\n%s\nWith these formatting options:\n%s".formatted(this.serialize((List<ChatFormatting>)validColors), this.serialize((List<ChatFormatting>)validFormats));
    }
}

