/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.recipe.category;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public interface IRecipeCategory<T> {
    default public RecipeType<T> getRecipeType() {
        return new RecipeType<T>(this.getUid(), this.getRecipeClass());
    }

    public Component getTitle();

    public IDrawable getBackground();

    public IDrawable getIcon();

    default public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        this.setRecipe(builder, recipe, focuses.getAllFocuses());
    }

    default public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.draw(recipe, stack, mouseX, mouseY);
    }

    default public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return this.getTooltipStrings(recipe, mouseX, mouseY);
    }

    default public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.getType() == InputConstants.Type.MOUSE) {
            return this.handleClick(recipe, mouseX, mouseY, input.getValue());
        }
        return false;
    }

    default public boolean isHandled(T recipe) {
        return true;
    }

    @Nullable
    default public ResourceLocation getRegistryName(T recipe) {
        if (recipe instanceof Recipe) {
            Recipe vanillaRecipe = (Recipe)recipe;
            return vanillaRecipe.getId();
        }
        return null;
    }

    @Deprecated(forRemoval=true, since="9.5.0")
    public ResourceLocation getUid();

    @Deprecated(forRemoval=true, since="9.5.0")
    public Class<? extends T> getRecipeClass();

    @Deprecated(forRemoval=true, since="8.3.0")
    default public boolean handleClick(T recipe, double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    @Deprecated(forRemoval=true, since="9.3.0")
    default public void setIngredients(T recipe, IIngredients ingredients) {
    }

    @Deprecated(forRemoval=true, since="9.4.0")
    default public void setRecipe(IRecipeLayoutBuilder builder, T recipe, List<? extends IFocus<?>> focuses) {
    }

    @Deprecated(forRemoval=true, since="9.3.0")
    default public void setRecipe(IRecipeLayout recipeLayout, T recipe, IIngredients ingredients) {
    }

    @Deprecated(forRemoval=true, since="9.3.0")
    default public void draw(T recipe, PoseStack stack, double mouseX, double mouseY) {
    }

    @Deprecated(forRemoval=true, since="9.3.0")
    default public List<Component> getTooltipStrings(T recipe, double mouseX, double mouseY) {
        return Collections.emptyList();
    }
}

