package mezz.jei.fabric.platform;

import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.fabric.ingredients.fluid.JeiFluidIngredient;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.render.FluidTankRenderer;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1058;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public class FluidHelper implements IPlatformFluidHelperInternal<IJeiFluidIngredient> {
    @Override
    public IIngredientTypeWithSubtypes<class_3611, IJeiFluidIngredient> getFluidIngredientType() {
        return FabricTypes.FLUID_STACK;
    }

    @Override
    public IIngredientSubtypeInterpreter<IJeiFluidIngredient> getAllNbtSubtypeInterpreter() {
        return AllFluidNbt.INSTANCE;
    }

    @Override
    public IIngredientRenderer<IJeiFluidIngredient> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<>(this, capacity, showCapacity, width, height);
    }

    @Override
    public class_1058 getStillFluidSprite(IJeiFluidIngredient ingredient) {
        FluidRenderHandlerRegistry registry = FluidRenderHandlerRegistry.INSTANCE;
        class_3611 fluid = ingredient.getFluid();
        FluidRenderHandler handler = registry.get(fluid);
        class_3610 defaultFluidState = fluid.method_15785();
        class_1058[] fluidSprites = handler.getFluidSprites(null, null, defaultFluidState);
        return fluidSprites[0];
    }

    @Override
    public class_2561 getDisplayName(IJeiFluidIngredient ingredient) {
        // TODO: better Fabric Fluid display name
        class_3611 fluid = ingredient.getFluid();
        class_2960 key = class_2378.field_11154.method_10221(fluid);
        String path = key.method_12832();
        path = path.replace("_", " ");
        path = StringUtils.capitalize(path);
        return new class_2585(path);
    }

    @Override
    public int getColorTint(IJeiFluidIngredient ingredient) {
        FluidRenderHandlerRegistry registry = FluidRenderHandlerRegistry.INSTANCE;
        class_3611 fluid = ingredient.getFluid();
        FluidRenderHandler handler = registry.get(fluid);
        class_3610 defaultFluidState = fluid.method_15785();
        int fluidColor = handler.getFluidColor(null, null, defaultFluidState);
        return fluidColor | 0xFF000000;
    }

    @Override
    public long getAmount(IJeiFluidIngredient ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public Optional<class_2487> getTag(IJeiFluidIngredient ingredient) {
        return ingredient.getTag();
    }

    @SuppressWarnings("UnstableApiUsage")
    @Override
    public long bucketVolume() {
        return FluidConstants.BUCKET;
    }

    @Override
    public IJeiFluidIngredient create(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return new JeiFluidIngredient(fluid, amount, tag);
    }

    @Override
    public IJeiFluidIngredient create(class_3611 fluid, long amount) {
        return new JeiFluidIngredient(fluid, amount);
    }

    @Override
    public IJeiFluidIngredient copy(IJeiFluidIngredient ingredient) {
        class_2487 tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), ingredient.getAmount(), tag);
    }

    @Override
    public IJeiFluidIngredient normalize(IJeiFluidIngredient ingredient) {
        class_2487 tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), bucketVolume(), tag);
    }

    private static class AllFluidNbt implements IIngredientSubtypeInterpreter<IJeiFluidIngredient> {
        public static final AllFluidNbt INSTANCE = new AllFluidNbt();

        private AllFluidNbt() {
        }

        @Override
        public String apply(IJeiFluidIngredient storage, UidContext context) {
            return storage.getTag()
                .filter(tag -> !tag.method_33133())
                .map(class_2487::toString)
                .orElse(IIngredientSubtypeInterpreter.NONE);
        }
    }
}
