package mezz.jei.fabric.mixin;

import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.common.Internal;
import mezz.jei.common.runtime.JeiRuntime;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import net.minecraft.class_485;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_485.class)
public abstract class EffectRenderingInventoryScreenMixin extends class_465<class_1703> {
    public EffectRenderingInventoryScreenMixin(class_1703 menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    @ModifyVariable(
        method = "renderEffects(Lcom/mojang/blaze3d/vertex/PoseStack;II)V",
        index = 7,
        name = "bl",
        at = @At("STORE")
    )
    public boolean modifyHasRoom(boolean bl) {
        boolean ingredientListDisplayed = Internal.getRuntime()
            .map(JeiRuntime::getIngredientListOverlay)
            .map(IIngredientListOverlay::isListDisplayed)
            .orElse(false);

        if (ingredientListDisplayed) {
            // make the potion effects think that there is not enough room,
            // so they render in compact mode.
            return false;
        }
        return bl;
    }
}
