package mezz.jei.fabric.events;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;

public class JeiScreenEvents {
    public static final Event<AfterRenderBackground> AFTER_RENDER_BACKGROUND =
        EventFactory.createArrayBacked(AfterRenderBackground.class, callbacks -> (screen, poseStack) -> {
            for (AfterRenderBackground callback : callbacks) {
                callback.afterRenderBackground(screen, poseStack);
            }
        });

    public static final Event<DrawForeground> DRAW_FOREGROUND =
        EventFactory.createArrayBacked(DrawForeground.class, callbacks -> (screen, poseStack, mouseX, mouseY) -> {
            for (DrawForeground callback : callbacks) {
                callback.drawForeground(screen, poseStack, mouseX, mouseY);
            }
        });


    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface AfterRenderBackground {
        void afterRenderBackground(class_437 screen, class_4587 poseStack);
    }

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface DrawForeground {
        void drawForeground(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY);
    }
}
