package mezz.jei.common.util;

import mezz.jei.core.util.PathUtil;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;

public final class ServerConfigPathUtil {
	private static final Path worldDirPath = Path.of("world");
	private static final ReflectionUtil reflectionUtil = new ReflectionUtil();

	private ServerConfigPathUtil() {

	}

	@Nullable
	public static Path getWorldPath(Path basePath) {
		Path worldPath = getWorldPath();
		if (worldPath == null) {
			return null;
		}
		return basePath.resolve(worldPath);
	}

	@Nullable
	private static Path getWorldPath() {
		class_310 minecraft = class_310.method_1551();
		class_634 clientPacketListener = minecraft.method_1562();
		if (clientPacketListener == null) {
			return null;
		}
		class_2535 connection = clientPacketListener.method_2872();
		if (connection.method_10756()) {
			MinecraftServer minecraftServer = minecraft.method_1576();
			if (minecraftServer != null) {
				return reflectionUtil.getFieldWithClass(minecraftServer, class_32.class_5143.class)
					.findFirst()
					.map(class_32.class_5143::method_27005)
					.map(PathUtil::sanitizePathName)
					.map(name -> worldDirPath.resolve("local").resolve(name))
					.orElse(null);
			}
		} else {
			class_642 serverData = minecraft.method_1558();
			if (serverData != null) {
				int ipHash = serverData.field_3761.hashCode();
				String ipHashHex = Integer.toHexString(ipHash);
				String name = String.format("%s_%s", serverData.field_3752, ipHashHex);
				name = PathUtil.sanitizePathName(name);
				return worldDirPath.resolve("server").resolve(name);
			}
		}
		return null;
	}
}
