package mezz.jei.common.util;

import org.jetbrains.annotations.Nullable;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1799;

public class MatchingIterable implements Iterable<ItemStackMatchable<class_1799>> {
	private final List<class_1799> ingredients;

	public MatchingIterable(List<class_1799> ingredients) {
		this.ingredients = ingredients;
	}

	@Override
	public Iterator<ItemStackMatchable<class_1799>> iterator() {
		Iterator<class_1799> stacks = ingredients.iterator();
		return new DelegateIterator<>(stacks) {
			@Override
			public ItemStackMatchable<ItemStack> next() {
				final ItemStack stack = delegate.next();
				return new ItemStackMatchable<>() {
					@Nullable
					@Override
					public ItemStack getStack() {
						return stack;
					}

					@Nullable
					@Override
					public ItemStack getResult() {
						return stack;
					}
				};
			}
		};
	}

	public static abstract class DelegateIterator<T, R> implements Iterator<R> {
		protected final Iterator<T> delegate;

		public DelegateIterator(Iterator<T> delegate) {
			this.delegate = delegate;
		}

		@Override
		public boolean hasNext() {
			return delegate.hasNext();
		}

		@Override
		public void remove() {
			delegate.remove();
		}
	}
}
