package mezz.jei.common.transfer;

/**
 * Represents transferring an ItemStack from inventorySlot to craftingSlot.
 */
public record TransferOperation(Slot inventorySlot, Slot craftingSlot) {
	public static TransferOperation readPacketData(FriendlyByteBuf buf, AbstractContainerMenu container) {
		int inventorySlotIndex = buf.readVarInt();
		int craftingSlotIndex = buf.readVarInt();

		Slot inventorySlot = container.getSlot(inventorySlotIndex);
		Slot craftingSlot = container.getSlot(craftingSlotIndex);
		return new TransferOperation(inventorySlot, craftingSlot);
	}

	public void writePacketData(FriendlyByteBuf buf) {
		buf.writeVarInt(inventorySlot.index);
		buf.writeVarInt(craftingSlot.index);
	}
}
