package mezz.jei.common.transfer;

import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.common.gui.ingredients.RecipeSlot;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import java.util.Set;

public class RecipeTransferErrorIngredientIndexes extends RecipeTransferErrorTooltip {
	private static final int HIGHLIGHT_COLOR = 0x66FF0000;

	private final Set<Integer> ingredientIndexes;

	public RecipeTransferErrorIngredientIndexes(class_2561 message, Set<Integer> ingredientIndexes) {
		super(message);
		this.ingredientIndexes = ingredientIndexes;
	}

	@Override
	public void showError(class_4587 poseStack, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
		poseStack.method_22903();
		{
			poseStack.method_22904(recipeX, recipeY, 0);

			for (IRecipeSlotView slotView : recipeSlotsView.getSlotViews()) {
				// casting this IRecipeSlotView to RecipeSlot is a hack for legacy support
				if (slotView instanceof RecipeSlot recipeSlot) {
					int legacyIngredientIndex = recipeSlot.getLegacyIngredientIndex();
					if (ingredientIndexes.contains(legacyIngredientIndex)) {
						recipeSlot.drawHighlight(poseStack, HIGHLIGHT_COLOR);
					}
				}
			}
		}
		poseStack.method_22909();
	}
}
