package mezz.jei.common.transfer;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.common.network.IConnectionToServer;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3955;
import mezz.jei.common.gui.ingredients.RecipeSlotsView;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;

public class PlayerRecipeTransferHandler implements IRecipeTransferHandler<class_1723, class_3955> {
	/**
	 * Indexes from the crafting recipe inputs that fit into the player crafting grid
	 * when we trim the right and bottom edges.
	 */
	private static final IntSet PLAYER_INV_INDEXES = IntArraySet.of(0, 1, 3, 4);

	private final IConnectionToServer serverConnection;
	private final IRecipeTransferHandlerHelper handlerHelper;
	private final IRecipeTransferHandler<class_1723, class_3955> handler;

	public PlayerRecipeTransferHandler(IConnectionToServer serverConnection, IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper) {
		this.serverConnection = serverConnection;
		this.handlerHelper = handlerHelper;
		var transferInfo = new BasicRecipeTransferInfo<>(class_1723.class, RecipeTypes.CRAFTING, 1, 4, 9, 36);
		this.handler = new BasicRecipeTransferHandler<>(serverConnection, stackHelper, handlerHelper, transferInfo);
	}

	@Override
	public Class<class_1723> getContainerClass() {
		return class_1723.class;
	}

	@Override
	public Class<class_3955> getRecipeClass() {
		return class_3955.class;
	}

	@Nullable
	@Override
	public IRecipeTransferError transferRecipe(class_1723 container, class_3955 recipe, IRecipeSlotsView recipeSlotsView, class_1657 player, boolean maxTransfer, boolean doTransfer) {
		if (!serverConnection.isJeiOnServer()) {
			class_2561 tooltipMessage = new class_2588("jei.tooltip.error.recipe.transfer.no.server");
			return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
		}

		List<IRecipeSlotView> slotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
		if (!validateIngredientsOutsidePlayerGridAreEmpty(slotViews)) {
			class_2561 tooltipMessage = new class_2588(
				"jei.tooltip.error.recipe.transfer.too.large.player.inventory"
			);
			return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
		}

		// filter the crafting table input slots to player inventory input slots
		List<IRecipeSlotView> filteredSlotViews = filterSlots(slotViews);
		RecipeSlotsView filteredRecipeSlots = new RecipeSlotsView(filteredSlotViews);
		return this.handler.transferRecipe(container, recipe, filteredRecipeSlots, player, maxTransfer, doTransfer);
	}

	private static boolean validateIngredientsOutsidePlayerGridAreEmpty(List<IRecipeSlotView> slotViews) {
		int bound = slotViews.size();
		for (int i = 0; i < bound; i++) {
			if (!PLAYER_INV_INDEXES.contains(i)) {
				IRecipeSlotView slotView = slotViews.get(i);
				if (!slotView.isEmpty()) {
					return false;
				}
			}
		}
		return true;
	}

	private static List<IRecipeSlotView> filterSlots(List<IRecipeSlotView> slotViews) {
		return PLAYER_INV_INDEXES.intStream()
			.mapToObj(slotViews::get)
			.toList();
	}
}
