package mezz.jei.common.transfer;

import java.util.ArrayList;
import java.util.List;

import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2960;

public class BasicRecipeTransferInfo<C extends class_1703, R> implements IRecipeTransferInfo<C, R> {
	private final Class<C> containerClass;
	private final RecipeType<R> recipeType;
	private final int recipeSlotStart;
	private final int recipeSlotCount;
	private final int inventorySlotStart;
	private final int inventorySlotCount;

	public BasicRecipeTransferInfo(Class<C> containerClass, RecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
		this.containerClass = containerClass;
		this.recipeType = recipeType;
		this.recipeSlotStart = recipeSlotStart;
		this.recipeSlotCount = recipeSlotCount;
		this.inventorySlotStart = inventorySlotStart;
		this.inventorySlotCount = inventorySlotCount;
	}

	@Override
	public Class<C> getContainerClass() {
		return containerClass;
	}

	@SuppressWarnings({"removal"})
	@Override
	public Class<R> getRecipeClass() {
		@SuppressWarnings("unchecked")
		Class<R> cast = (Class<R>) recipeType.getRecipeClass();
		return cast;
	}

	@SuppressWarnings("removal")
	@Override
	public class_2960 getRecipeCategoryUid() {
		return recipeType.getUid();
	}

	@Override
	public RecipeType<R> getRecipeType() {
		return recipeType;
	}

	@Override
	public boolean canHandle(C container, R recipe) {
		return true;
	}

	@Override
	public List<class_1735> getRecipeSlots(C container, R recipe) {
		List<class_1735> slots = new ArrayList<>();
		for (int i = recipeSlotStart; i < recipeSlotStart + recipeSlotCount; i++) {
			class_1735 slot = container.method_7611(i);
			slots.add(slot);
		}
		return slots;
	}

	@Override
	public List<class_1735> getInventorySlots(C container, R recipe) {
		List<class_1735> slots = new ArrayList<>();
		for (int i = inventorySlotStart; i < inventorySlotStart + inventorySlotCount; i++) {
			class_1735 slot = container.method_7611(i);
			slots.add(slot);
		}
		return slots;
	}
}
