package mezz.jei.common.plugins.vanilla.ingredients.item;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.color.ColorGetter;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class ItemStackHelper implements IIngredientHelper<class_1799> {
	private final StackHelper stackHelper;

	public ItemStackHelper(StackHelper stackHelper) {
		this.stackHelper = stackHelper;
	}

	@Override
	public IIngredientType<class_1799> getIngredientType() {
		return VanillaTypes.ITEM_STACK;
	}

	@Override
	public String getDisplayName(class_1799 ingredient) {
		class_2561 displayNameTextComponent = ingredient.method_7964();
		String displayName = displayNameTextComponent.getString();
		ErrorUtil.checkNotNull(displayName, "itemStack.getDisplayName()");
		return displayName;
	}

	@Override
	public String getUniqueId(class_1799 ingredient, UidContext context) {
		ErrorUtil.checkNotEmpty(ingredient);
		return stackHelper.getUniqueIdentifierForStack(ingredient, context);
	}

	@Override
	public String getWildcardId(class_1799 ingredient) {
		ErrorUtil.checkNotEmpty(ingredient);
		return StackHelper.getRegistryNameForStack(ingredient);
	}

	@SuppressWarnings("removal")
	@Override
	public String getModId(class_1799 ingredient) {
		class_2960 resourceLocation = getResourceLocation(ingredient);
		return resourceLocation.method_12836();
	}

	@Override
	public String getDisplayModId(class_1799 ingredient) {
		ErrorUtil.checkNotEmpty(ingredient);

		IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
		String modId = itemStackHelper.getCreatorModId(ingredient);
		if (modId == null) {
			IPlatformRegistry<class_1792> registry = Services.PLATFORM.getRegistry(class_2378.field_25108);
			class_2960 registryName = registry.getRegistryName(ingredient.method_7909());
			if (registryName == null) {
				String stackInfo = getErrorInfo(ingredient);
				throw new IllegalStateException("null registryName for: " + stackInfo);
			}
			modId = registryName.method_12836();
		}
		return modId;
	}

	@Override
	public Iterable<Integer> getColors(class_1799 ingredient) {
		return ColorGetter.getColors(ingredient, 2);
	}

	@SuppressWarnings("removal")
	@Override
	public String getResourceId(class_1799 ingredient) {
		class_2960 resourceLocation = getResourceLocation(ingredient);
		return resourceLocation.method_12832();
	}

	@Override
	public class_2960 getResourceLocation(class_1799 ingredient) {
		ErrorUtil.checkNotEmpty(ingredient);

		class_1792 item = ingredient.method_7909();
		IPlatformRegistry<class_1792> itemRegistry = Services.PLATFORM.getRegistry(class_2378.field_25108);
		class_2960 name = itemRegistry.getRegistryName(item);
		if (name == null) {
			String stackInfo = getErrorInfo(ingredient);
			throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
		}

		return name;
	}

	@Override
	public class_1799 getCheatItemStack(class_1799 ingredient) {
		return ingredient;
	}

	@Override
	public class_1799 copyIngredient(class_1799 ingredient) {
		return ingredient.method_7972();
	}

	@Override
	public class_1799 normalizeIngredient(class_1799 ingredient) {
		class_1799 copy = ingredient.method_7972();
		copy.method_7939(1);
		return copy;
	}

	@Override
	public boolean isValidIngredient(class_1799 ingredient) {
		return !ingredient.method_7960();
	}

	@Override
	public boolean isIngredientOnServer(class_1799 ingredient) {
		class_1792 item = ingredient.method_7909();
		IPlatformRegistry<class_1792> registry = Services.PLATFORM.getRegistry(class_2378.field_25108);
		return registry.contains(item);
	}

	@Override
	public Collection<class_2960> getTags(class_1799 ingredient) {
		return TagUtil.getTags(ingredient.method_40133());
	}

	@Override
	public Collection<String> getCreativeTabNames(class_1799 ingredient) {
		Collection<String> creativeTabsStrings = new ArrayList<>();
		IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
		for (class_1761 itemGroup : itemStackHelper.getCreativeTabs(ingredient)) {
			if (itemGroup != null) {
				String creativeTabName = itemGroup.method_7737().getString();
				creativeTabsStrings.add(creativeTabName);
			}
		}
		return creativeTabsStrings;
	}

	@Override
	public String getErrorInfo(@Nullable class_1799 ingredient) {
		return ErrorUtil.getItemStackInfo(ingredient);
	}

	@Override
	public Optional<class_2960> getTagEquivalent(Collection<class_1799> ingredients) {
		return TagUtil.getTagEquivalent(ingredients, class_1799::method_7909, class_2378.field_11142::method_40272);
	}
}
