package mezz.jei.common.plugins.debug;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.ModIds;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.config.ClientConfig;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredientHelper;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredientListFactory;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredientRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_472;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

@JeiPlugin
public class JeiDebugPlugin implements IModPlugin {
	@Nullable
	public static IIngredientManager ingredientManager;
	@Nullable
	public static IJeiRuntime jeiRuntime;

	@Override
	public class_2960 getPluginUid() {
		return new class_2960(ModIds.JEI_ID, "debug");
	}

	@Override
	public void registerIngredients(IModIngredientRegistration registration) {
		if (ClientConfig.getInstance().isDebugModeEnabled()) {
			DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
			DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
			registration.register(DebugIngredient.TYPE, Collections.emptyList(), ingredientHelper, ingredientRenderer);
		}
	}

	@Override
	public void registerCategories(IRecipeCategoryRegistration registration) {
		if (ClientConfig.getInstance().isDebugModeEnabled()) {
			IJeiHelpers jeiHelpers = registration.getJeiHelpers();
			IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
			IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
			registration.addRecipeCategories(
				new DebugRecipeCategory<>(guiHelper, platformFluidHelper),
				new DebugFocusRecipeCategory<>(guiHelper, platformFluidHelper),
				new LegacyDebugRecipeCategory<>(guiHelper, platformFluidHelper)
			);
		}
	}

	@Override
	public void registerRecipes(IRecipeRegistration registration) {
		JeiDebugPlugin.ingredientManager = registration.getIngredientManager();

		if (ClientConfig.getInstance().isDebugModeEnabled()) {
			registration.addItemStackInfo(List.of(
				new class_1799(class_2246.field_10149),
				new class_1799(class_2246.field_10521),
				new class_1799(class_2246.field_10352),
				new class_1799(class_2246.field_10627),
				new class_1799(class_2246.field_10232),
				new class_1799(class_2246.field_10403)
				),
				new class_2588("description.jei.wooden.door.1"), // actually 2 lines
				new class_2588("description.jei.wooden.door.2"),
				new class_2588("description.jei.wooden.door.3")
			);

			IJeiHelpers jeiHelpers = registration.getJeiHelpers();
			IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
			registerFluidRecipes(registration, platformFluidHelper);
			registration.addIngredientInfo(new DebugIngredient(1), DebugIngredient.TYPE, new class_2585("debug"));
			registration.addIngredientInfo(new DebugIngredient(2), DebugIngredient.TYPE,
				new class_2585("debug colored").method_27692(class_124.field_1075),
				new class_2585("debug\\nSplit and colored").method_27692(class_124.field_1076),
				new class_2588("description.jei.debug.formatting.1", "various"),
				new class_2588("description.jei.debug.formatting.1", "various\\nsplit"),
				new class_2588("description.jei.debug.formatting.1", new class_2585("various colored").method_27692(class_124.field_1061)),
				new class_2588("description.jei.debug.formatting.1",
					new class_2585("various\\nsplit colored").method_27692(class_124.field_1062)
				),
				new class_2588("description.jei.debug.formatting.1", "\\nSplitting at the start"),
				new class_2588("description.jei.debug.formatting.1", "various all colored").method_27692(class_124.field_1061),
				new class_2588("description.jei.debug.formatting.1",
					new class_2588("description.jei.debug.formatting.3", "various").method_27692(class_124.field_1062)
				),
				new class_2588("description.jei.debug.formatting.2",
					new class_2585("multiple").method_27692(class_124.field_1065).method_27692(class_124.field_1056),
					new class_2585("various").method_27692(class_124.field_1061)
				).method_27692(class_124.field_1078),
				new class_2588("description.jei.debug.formatting.1",
					new class_2588("description.jei.debug.formatting.3",
						new class_2588("description.jei.debug.formatting.2",
							new class_2585("multiple").method_27692(class_124.field_1065).method_27692(class_124.field_1056),
							new class_2585("various").method_27692(class_124.field_1061)
						).method_27692(class_124.field_1062)
					)
				)
			);

			registration.addRecipes(DebugRecipeCategory.TYPE, List.of(
				new DebugRecipe(),
				new DebugRecipe()
			));

			registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(
				new DebugRecipe()
			));

			//noinspection removal
			registration.addRecipes(List.of(
				new DebugRecipe(),
				new DebugRecipe()
			), LegacyDebugRecipeCategory.UID);
		}
	}

	private <T> void registerFluidRecipes(IRecipeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
		long bucketVolume = platformFluidHelper.bucketVolume();
		T fluidIngredient = platformFluidHelper.create(class_3612.field_15910, bucketVolume, null);
		registration.addIngredientInfo(fluidIngredient, platformFluidHelper.getFluidIngredientType(), new class_2585("water"));
	}

	@Override
	public void registerGuiHandlers(IGuiHandlerRegistration registration) {
		if (ClientConfig.getInstance().isDebugModeEnabled()) {
			registration.addGuiContainerHandler(class_472.class, new IGuiContainerHandler<>() {
				@Override
				public List<Rect2i> getGuiExtraAreas(BrewingStandScreen containerScreen) {
					int widthMovement = (int) ((System.currentTimeMillis() / 100) % 100);
					int size = 25 + widthMovement;
					IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
					int guiLeft = screenHelper.getGuiLeft(containerScreen);
					int xSize = screenHelper.getXSize(containerScreen);
					int guiTop = screenHelper.getGuiTop(containerScreen);
					return List.of(
						new Rect2i(guiLeft + xSize, guiTop + 40, size, size)
					);
				}

				@Nullable
				@Override
				public Object getIngredientUnderMouse(BrewingStandScreen containerScreen, double mouseX, double mouseY) {
					if (mouseX < 10 && mouseY < 10) {
						IPlatformFluidHelper<?> fluidHelper = Services.PLATFORM.getFluidHelper();
						long bucketVolume = fluidHelper.bucketVolume();
						return fluidHelper.create(Fluids.WATER, bucketVolume, null);
					}
					return null;
				}
			});

			registration.addGhostIngredientHandler(class_472.class, new DebugGhostIngredientHandler<>());
		}
	}

	@Override
	public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
		class_3611 water = class_3612.field_15910;
		IIngredientTypeWithSubtypes<class_3611, T> ingredientType = platformFluidHelper.getFluidIngredientType();
		FluidSubtypeHandlerTest<T> subtype = new FluidSubtypeHandlerTest<>(ingredientType);
		registration.registerSubtypeInterpreter(ingredientType, water, subtype);
	}

	@Override
	public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
		if (ClientConfig.getInstance().isDebugModeEnabled()) {
			IPlatformFluidHelper<?> fluidHelper = Services.PLATFORM.getFluidHelper();
			registerRecipeCatalysts(registration, fluidHelper);
		}
	}

	private <T> void registerRecipeCatalysts(IRecipeCatalystRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
		long bucketVolume = fluidHelper.bucketVolume();

		registration.addRecipeCatalyst(DebugIngredient.TYPE, new DebugIngredient(7), DebugRecipeCategory.TYPE);
		registration.addRecipeCatalyst(fluidHelper.getFluidIngredientType(), fluidHelper.create(class_3612.field_15910, bucketVolume, null), DebugRecipeCategory.TYPE);
		registration.addRecipeCatalyst(new class_1799(class_1802.field_8600), DebugRecipeCategory.TYPE);
		IPlatformRegistry<class_1792> registry = Services.PLATFORM.getRegistry(class_2378.field_25108);
		registry.getValues()
			.limit(30)
			.forEach(item -> {
				class_1799 catalystIngredient = new class_1799(item);
				if (!catalystIngredient.method_7960()) {
					registration.addRecipeCatalyst(catalystIngredient, DebugRecipeCategory.TYPE);
				}
			});
	}

	@Override
	public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
		JeiDebugPlugin.jeiRuntime = jeiRuntime;

		if (ClientConfig.getInstance().isDebugModeEnabled()) {
			IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
			ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
		}
	}
}
