package mezz.jei.common.plugins.debug;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class FluidSubtypeHandlerTest<T> implements IIngredientSubtypeInterpreter<T> {
	private final IIngredientTypeWithSubtypes<class_3611, T> type;

	public FluidSubtypeHandlerTest(IIngredientTypeWithSubtypes<class_3611, T> type) {
		this.type = type;
	}

	@Override
	public String apply(T fluidStack, UidContext context) {
		class_3611 fluid = type.getBase(fluidStack);
		IPlatformRegistry<class_3611> registry = Services.PLATFORM.getRegistry(class_2378.field_25103);
		class_2960 name = registry.getRegistryName(fluid);
		if (name != null) {
			return name.toString();
		} else {
			throw new IllegalArgumentException("Fluid has no registry name! " + fluid);
		}
	}
}
