package mezz.jei.common.plugins.debug;

import mezz.jei.common.Internal;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class DebugGhostIngredientHandler<T extends class_465<?>> implements IGhostIngredientHandler<T> {
	private static final Logger LOGGER = LogManager.getLogger();

	@Override
	public <I> List<Target<I>> getTargets(T gui, I ingredient, boolean doStart) {
		List<Target<I>> targets = new ArrayList<>();
		targets.add(new DebugInfoTarget<>("Got an Ingredient", new class_768(0, 0, 20, 20)));
		if (doStart) {
			RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
			IIngredientType<I> ingredientType = registeredIngredients.getIngredientType(ingredient);
			IIngredientHelper<I> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
			LOGGER.info("Ghost Ingredient Handling Starting with {}", ingredientHelper.getErrorInfo(ingredient));
			targets.add(new DebugInfoTarget<>("Got an Ingredient", new class_768(20, 20, 20, 20)));
		}
		if (ingredient instanceof class_1799) {
			boolean even = true;
			IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
			for (class_1735 slot : gui.method_17577().field_7761) {
				if (even) {
					int guiLeft = screenHelper.getGuiLeft(gui);
					int guiTop = screenHelper.getGuiTop(gui);
					class_768 area = new class_768(guiLeft + slot.field_7873, guiTop + slot.field_7872, 16, 16);
					targets.add(new DebugInfoTarget<>("Got an Ingredient in Gui", area));
				}
				even = !even;
			}
		}
		return targets;
	}

	@Override
	public void onComplete() {
		LOGGER.info("Ghost Ingredient Handling Complete");
	}

	private static class DebugInfoTarget<I> implements IGhostIngredientHandler.Target<I> {
		private final String message;
		private final class_768 rectangle;

		public DebugInfoTarget(String message, class_768 rectangle) {
			this.message = message;
			this.rectangle = rectangle;
		}

		@Override
		public class_768 getArea() {
			return rectangle;
		}

		@Override
		public void accept(I ingredient) {
			RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
			IIngredientType<I> ingredientType = registeredIngredients.getIngredientType(ingredient);
			IIngredientHelper<I> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
			LOGGER.info("{}: {}", message, ingredientHelper.getErrorInfo(ingredient));
		}
	}
}
