package mezz.jei.common.platform;

import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import net.minecraft.class_1058;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import java.util.Optional;

public interface IPlatformFluidHelperInternal<T> extends IPlatformFluidHelper<T> {

    IIngredientSubtypeInterpreter<T> getAllNbtSubtypeInterpreter();

    IIngredientRenderer<T> createRenderer(long capacity, boolean showCapacity, int width, int height);

    class_1058 getStillFluidSprite(T ingredient);

    class_2561 getDisplayName(T ingredient);

    int getColorTint(T ingredient);

    long getAmount(T ingredient);

    Optional<class_2487> getTag(T ingredient);

    T copy(T ingredient);

    T normalize(T ingredient);
}
