package mezz.jei.common.network.packets;

import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.concurrent.CompletableFuture;

public class PacketRequestCheatPermission extends PacketJei {
	@Override
	public IPacketId getPacketId() {
		return PacketIdServer.CHEAT_PERMISSION_REQUEST;
	}

	@Override
	public void writePacketData(class_2540 buf) {
		// the packet itself is the only data needed
	}

	public static CompletableFuture<Void> readPacketData(ServerPacketData data) {
		ServerPacketContext context = data.context();
		class_3222 player = context.player();
		IServerConfig serverConfig = context.serverConfig();
		MinecraftServer server = player.field_13995;
		return server.method_20493(() -> {
			boolean hasPermission = ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig);
			PacketCheatPermission packetCheatPermission = new PacketCheatPermission(hasPermission);

			IConnectionToClient connection = context.connection();
			connection.sendPacketToClient(packetCheatPermission, player);
		});
	}
}
