package mezz.jei.common.input.keys;

import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public enum JeiKeyModifier {
    CONTROL_OR_COMMAND {
        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            return class_437.method_25441();
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key) {
            if (class_310.field_1703) {
                return new class_2588("jei.key.combo.command", key.method_27445());
            } else {
                return new class_2588("jei.key.combo.control", key.method_27445());
            }
        }
    },
    SHIFT {
        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            return class_437.method_25442();
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key) {
            return new class_2588("jei.key.combo.shift", key.method_27445());
        }
    },
    ALT {
        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            return class_437.method_25443();
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key) {
            return new class_2588("jei.key.combo.alt", key.method_27445());
        }
    },
    NONE {
        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            if (context.conflicts(JeiKeyConflictContext.IN_GAME)) {
                return true;
            }
            return !CONTROL_OR_COMMAND.isActive(context) &&
                !SHIFT.isActive(context) &&
                !ALT.isActive(context);
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key) {
            return key.method_27445();
        }
    };

    public abstract boolean isActive(JeiKeyConflictContext context);

    public abstract class_2561 getCombinedName(class_3675.class_306 key);
}
