package mezz.jei.common.input;

import java.util.Optional;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public interface IUserInputHandler {
	default Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IKeyBindings keyBindings) {
		return Optional.empty();
	}

	/**
	 * Called when a mouse is clicked but was handled and canceled by some other mouse handler.
	 */
	default void handleMouseClickedOut(class_3675.class_306 key) {

	}

	default boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
		return false;
	}

	default Optional<IUserInputHandler> handleDragStart(class_437 screen, UserInput input) {
		return Optional.empty();
	}

	default Optional<IUserInputHandler> handleDragComplete(class_437 screen, UserInput input) {
		return Optional.empty();
	}

	default void handleDragCanceled() {

	}
}
