package mezz.jei.common.input;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import java.util.Optional;
import java.util.stream.Stream;

public class GuiContainerWrapper implements IRecipeFocusSource {
	private final RegisteredIngredients registeredIngredients;
	private final GuiScreenHelper guiScreenHelper;

	public GuiContainerWrapper(RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper) {
		this.registeredIngredients = registeredIngredients;
		this.guiScreenHelper = guiScreenHelper;
	}

	@Override
	public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
		class_437 guiScreen = class_310.method_1551().field_1755;
		if (!(guiScreen instanceof class_465<?> guiContainer)) {
			return Stream.empty();
		}
		return Stream.concat(
			guiScreenHelper.getPluginsIngredientUnderMouse(guiContainer, mouseX, mouseY),
			getSlotIngredientUnderMouse(guiContainer).stream()
		);
	}

	private Optional<IClickedIngredient<?>> getSlotIngredientUnderMouse(class_465<?> guiContainer) {
		IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
		return Optional.ofNullable(screenHelper.getSlotUnderMouse(guiContainer))
			.flatMap(slot -> getClickedIngredient(slot, guiContainer));
	}

	private Optional<IClickedIngredient<?>> getClickedIngredient(class_1735 slot, class_465<?> guiContainer) {
		class_1799 stack = slot.method_7677();
		return TypedIngredient.createTyped(this.registeredIngredients, VanillaTypes.ITEM_STACK, stack)
			.map(typedIngredient -> {
				IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
				ImmutableRect2i slotArea = new ImmutableRect2i(
					screenHelper.getGuiLeft(guiContainer) + slot.field_7873,
					screenHelper.getGuiTop(guiContainer) + slot.field_7872,
					16,
					16
				);
				return new ClickedIngredient<>(typedIngredient, slotArea, false, false);
			});
	}
}
