package mezz.jei.common.gui.recipes.layout;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.GuiIconButtonSmall;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.gui.recipes.IOnClickHandler;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class RecipeTransferButton extends GuiIconButtonSmall {
	public static final int RECIPE_BUTTON_SIZE = 13;

	private final IRecipeLayoutInternal<?> recipeLayout;
	@Nullable
	private IRecipeTransferError recipeTransferError;
	@Nullable
	private IOnClickHandler onClickHandler;

	public RecipeTransferButton(int xPos, int yPos, IDrawable icon, IRecipeLayoutInternal<?> recipeLayout, Textures textures) {
		super(xPos, yPos, RECIPE_BUTTON_SIZE, RECIPE_BUTTON_SIZE, icon, b -> {}, textures);
		this.recipeLayout = recipeLayout;
	}

	public void init(RecipeTransferManager recipeTransferManager, @Nullable class_1703 container, class_1657 player) {
		if (container != null) {
			this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, recipeLayout, player);
		} else {
			this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
		}

		if (RecipeTransferUtil.allowsTransfer(recipeTransferError)) {
			this.field_22763 = true;
			this.field_22764 = true;
		} else {
			this.field_22763 = false;
			IRecipeTransferError.Type type = this.recipeTransferError.getType();
			this.field_22764 = (type == IRecipeTransferError.Type.USER_FACING);
		}
	}

	@SuppressWarnings("removal")
	public void drawToolTip(class_4587 poseStack, int mouseX, int mouseY) {
		if (method_25405(mouseX, mouseY)) {
			if (recipeTransferError == null) {
				class_2588 tooltipTransfer = new class_2588("jei.tooltip.transfer");
				TooltipRenderer.drawHoveringText(poseStack, List.of(tooltipTransfer), mouseX, mouseY);
			} else {
				RecipeSlots recipeSlots = recipeLayout.getRecipeSlots();
				IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
				recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, recipeLayout.getPosX(), recipeLayout.getPosY());
				recipeTransferError.showError(poseStack, mouseX, mouseY, recipeLayout.getLegacyAdapter(), recipeLayout.getPosX(), recipeLayout.getPosY());
			}
		}
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return this.field_22764 &&
			mouseX >= this.field_22760 &&
			mouseY >= this.field_22761 &&
			mouseX < this.field_22760 + this.field_22758 &&
			mouseY < this.field_22761 + this.field_22759;
	}

	@Override
	public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(poseStack, mouseX, mouseY, partialTicks);
		if (this.field_22764 && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
			method_25294(poseStack, this.field_22760, this.field_22761, this.field_22760 + this.field_22758, this.field_22761 + this.field_22759, this.recipeTransferError.getButtonHighlightColor());
		}
	}

	public void setOnClickHandler(IOnClickHandler onClickHandler) {
		this.onClickHandler = onClickHandler;
	}

	@Override
	public void method_25357(double mouseX, double mouseY) {
		if (!method_25405(mouseX, mouseY)) {
			return;
		}
		if (onClickHandler != null) {
			onClickHandler.onClick(mouseX, mouseY);
		}
	}
}
