package mezz.jei.common.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.common.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.UserInput;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import mezz.jei.common.input.IUserInputHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RecipeCategoryTab extends RecipeGuiTab {
	private final IRecipeGuiLogic logic;
	private final IRecipeCategory<?> category;

	public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, Textures textures, int x, int y) {
		super(textures, x, y);
		this.logic = logic;
		this.category = category;
	}

	@Override
	public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IKeyBindings keyBindings) {
		if (!isMouseOver(input.getMouseX(), input.getMouseY())) {
			return Optional.empty();
		}
		if (input.is(keyBindings.getLeftClick())) {
			if (!input.isSimulate()) {
				logic.setRecipeCategory(category);
				class_1144 soundHandler = class_310.method_1551().method_1483();
				soundHandler.method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
			}
			return Optional.of(this);
		}
		return Optional.empty();
	}

	@Override
	public void draw(boolean selected, class_4587 poseStack, int mouseX, int mouseY) {
		super.draw(selected, poseStack, mouseX, mouseY);

		int iconX = x + 4;
		int iconY = y + 4;

		IDrawable icon = category.getIcon();
		//noinspection ConstantConditions
		if (icon != null) {
			iconX += (16 - icon.getWidth()) / 2;
			iconY += (16 - icon.getHeight()) / 2;
			icon.draw(poseStack, iconX, iconY);
		} else {
			Optional<ITypedIngredient<?>> firstCatalyst = logic.getRecipeCatalysts(category)
				.findFirst();
			if (firstCatalyst.isPresent()) {
				ITypedIngredient<?> ingredient = firstCatalyst.get();
				renderIngredient(poseStack, iconX, iconY, ingredient);
			} else {
				String text = category.getTitle().getString().substring(0, 2);
				class_310 minecraft = class_310.method_1551();
				class_327 fontRenderer = minecraft.field_1772;
				int textCenterX = x + (TAB_WIDTH / 2);
				int textCenterY = y + (TAB_HEIGHT / 2) - 3;
				int color = isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
				int stringCenter = fontRenderer.method_1727(text) / 2;
				fontRenderer.method_1720(poseStack, text, textCenterX - stringCenter, textCenterY, color);
				RenderSystem.setShaderColor(1, 1, 1, 1);
			}
		}
	}

	private static <T> void renderIngredient(class_4587 poseStack, int iconX, int iconY, ITypedIngredient<T> ingredient) {
		RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
		IIngredientRenderer<T> ingredientRenderer = registeredIngredients.getIngredientRenderer(ingredient.getType());
		poseStack.method_22903();
		{
			poseStack.method_22904(iconX, iconY, 0);
			RenderSystem.enableDepthTest();
			ingredientRenderer.render(poseStack, ingredient.getIngredient());
			RenderSystem.disableDepthTest();
		}
		poseStack.method_22909();
	}

	@Override
	public boolean isSelected(IRecipeCategory<?> selectedCategory) {
		class_2960 categoryUid = category.getRecipeType().getUid();
		class_2960 selectedCategoryUid = selectedCategory.getRecipeType().getUid();
		return categoryUid.equals(selectedCategoryUid);
	}

	@Override
	public List<class_2561> getTooltip() {
		List<class_2561> tooltip = new ArrayList<>();
		class_2561 title = category.getTitle();
		//noinspection ConstantConditions
		if (title != null) {
			tooltip.add(title);
		}

		class_2960 uid = category.getRecipeType().getUid();
		String modId = uid.method_12836();
		IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
		if (modIdHelper.isDisplayingModNameEnabled()) {
			String modName = modIdHelper.getFormattedModNameForModId(modId);
			tooltip.add(new class_2585(modName));
		}
		return tooltip;
	}
}
