package mezz.jei.common.gui.recipes;

import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.ingredients.RegisteredIngredients;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import java.util.List;
import java.util.Optional;

public class OutputSlotTooltipCallback implements IRecipeSlotTooltipCallback {
	private final class_2960 recipeName;
	private final IModIdHelper modIdHelper;
	private final RegisteredIngredients registeredIngredients;

	public OutputSlotTooltipCallback(
		class_2960 recipeName,
		IModIdHelper modIdHelper,
		RegisteredIngredients registeredIngredients
	) {
		this.recipeName = recipeName;
		this.modIdHelper = modIdHelper;
		this.registeredIngredients = registeredIngredients;
	}

	@Override
	public void onTooltip(IRecipeSlotView recipeSlotView, List<class_2561> tooltip) {
		if (recipeSlotView.getRole() != RecipeIngredientRole.OUTPUT) {
			return;
		}
		Optional<ITypedIngredient<?>> displayedIngredient = recipeSlotView.getDisplayedIngredient();
		if (displayedIngredient.isEmpty()) {
			return;
		}

		if (modIdHelper.isDisplayingModNameEnabled()) {
			class_2960 ingredientName = getResourceLocation(displayedIngredient.get());

			String recipeModId = recipeName.method_12836();
			String ingredientModId = ingredientName.method_12836();
			if (!recipeModId.equals(ingredientModId)) {
				String modName = modIdHelper.getFormattedModNameForModId(recipeModId);
				class_2588 recipeBy = new class_2588("jei.tooltip.recipe.by", modName);
				tooltip.add(recipeBy.method_27692(class_124.field_1080));
			}
		}

		class_310 minecraft = class_310.method_1551();
		boolean showAdvanced = minecraft.field_1690.field_1827 || class_437.method_25442();
		if (showAdvanced) {
			class_2588 recipeId = new class_2588("jei.tooltip.recipe.id", recipeName.toString());
			tooltip.add(recipeId.method_27692(class_124.field_1063));
		}
	}

	private <T> class_2960 getResourceLocation(ITypedIngredient<T> ingredient) {
		IIngredientHelper<T> ingredientHelper = registeredIngredients.getIngredientHelper(ingredient.getType());
		return ingredientHelper.getResourceLocation(ingredient.getIngredient());
	}
}
