package mezz.jei.common.color;

import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_3532;
import net.minecraft.class_763;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ColorGetter implements IColorHelper {

	public static final ColorGetter INSTANCE = new ColorGetter();

	private static final Logger LOGGER = LogManager.getLogger();
	private static final List<ColorName> defaultColors = List.of(
		new ColorName("White", 0xEEEEEE),
		new ColorName("LightBlue", 0x7492cc),
		new ColorName("Cyan", 0x00EEEE),
		new ColorName("Blue", 0x2222dd),
		new ColorName("LapisBlue", 0x25418b),
		new ColorName("Teal", 0x008080),
		new ColorName("Yellow", 0xcacb58),
		new ColorName("GoldenYellow", 0xEED700),
		new ColorName("Orange", 0xd97634),
		new ColorName("Pink", 0xD1899D),
		new ColorName("HotPink", 0xFC0FC0),
		new ColorName("Magenta", 0xb24bbb),
		new ColorName("Purple", 0x813eb9),
		new ColorName("EvilPurple", 0x2e1649),
		new ColorName("Lavender", 0xB57EDC),
		new ColorName("Indigo", 0x480082),
		new ColorName("Sand", 0xdbd3a0),
		new ColorName("Tan", 0xbb9b63),
		new ColorName("LightBrown", 0xA0522D),
		new ColorName("Brown", 0x634b33),
		new ColorName("DarkBrown", 0x3a2d13),
		new ColorName("LimeGreen", 0x43b239),
		new ColorName("SlimeGreen", 0x83cb73),
		new ColorName("Green", 0x008000),
		new ColorName("DarkGreen", 0x224d22),
		new ColorName("GrassGreen", 0x548049),
		new ColorName("Red", 0x963430),
		new ColorName("BrickRed", 0xb0604b),
		new ColorName("NetherBrick", 0x2a1516),
		new ColorName("Redstone", 0xce3e36),
		new ColorName("Black", 0x181515),
		new ColorName("CharcoalGray", 0x464646),
		new ColorName("IronGray", 0x646464),
		new ColorName("Gray", 0x808080),
		new ColorName("Silver", 0xC0C0C0)
	);

	private ColorGetter() {

	}

	public static List<ColorName> getColorDefaults() {
		return defaultColors;
	}

	public static List<Integer> getColors(class_1799 itemStack, int colorCount) {
		try {
			return unsafeGetColors(itemStack, colorCount);
		} catch (RuntimeException | LinkageError e) {
			String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
			LOGGER.debug("Failed to get color name for {}", itemStackInfo, e);
			return Collections.emptyList();
		}
	}

	private static List<Integer> unsafeGetColors(class_1799 itemStack, int colorCount) {
		final class_1792 item = itemStack.method_7909();
		if (itemStack.method_7960()) {
			return Collections.emptyList();
		} else if (item instanceof final class_1747 itemBlock) {
			final class_2248 block = itemBlock.method_7711();
			//noinspection ConstantConditions
			if (block == null) {
				return Collections.emptyList();
			}
			return getBlockColors(block, colorCount);
		} else {
			return getItemColors(itemStack, colorCount);
		}
	}

	private static List<Integer> getItemColors(class_1799 itemStack, int colorCount) {
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		final class_325 itemColors = renderHelper.getItemColors();
		final int renderColor = itemColors.method_1704(itemStack, 0);
		final class_1058 textureAtlasSprite = getTextureAtlasSprite(itemStack);
		if (textureAtlasSprite == null) {
			return Collections.emptyList();
		}
		return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
	}

	private static List<Integer> getBlockColors(class_2248 block, int colorCount) {
		class_2680 blockState = block.method_9564();
		final class_324 blockColors = class_310.method_1551().method_1505();
		final int renderColor = blockColors.method_1697(blockState, null, null, 0);
		final class_1058 textureAtlasSprite = getTextureAtlasSprite(blockState);
		if (textureAtlasSprite == null) {
			return Collections.emptyList();
		}
		return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
	}

	@Override
	public List<Integer> getColors(class_1058 textureAtlasSprite, int renderColor, int colorCount) {
		if (colorCount <= 0) {
			return Collections.emptyList();
		}
		final class_1011 bufferedImage = getNativeImage(textureAtlasSprite);
		if (bufferedImage == null) {
			return Collections.emptyList();
		}
		final List<Integer> colors = new ArrayList<>(colorCount);
		final int[][] palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false);
		for (int[] colorInt : palette) {
			int red = (int) ((colorInt[0] - 1) * (float) (renderColor >> 16 & 255) / 255.0F);
			int green = (int) ((colorInt[1] - 1) * (float) (renderColor >> 8 & 255) / 255.0F);
			int blue = (int) ((colorInt[2] - 1) * (float) (renderColor & 255) / 255.0F);
			red = class_3532.method_15340(red, 0, 255);
			green = class_3532.method_15340(green, 0, 255);
			blue = class_3532.method_15340(blue, 0, 255);
			int color = ((0xFF) << 24) |
				((red & 0xFF) << 16) |
				((green & 0xFF) << 8) |
				(blue & 0xFF);
			colors.add(color);
		}
		return colors;
	}

	@Nullable
	private static class_1011 getNativeImage(class_1058 textureAtlasSprite) {
		final int iconWidth = textureAtlasSprite.method_4578();
		final int iconHeight = textureAtlasSprite.method_4595();
		if (iconWidth <= 0 || iconHeight <= 0) {
			return null;
		}

		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		return renderHelper.getMainImage(textureAtlasSprite);
	}

	@Nullable
	private static class_1058 getTextureAtlasSprite(class_2680 blockState) {
		class_310 minecraft = class_310.method_1551();
		class_776 blockRendererDispatcher = minecraft.method_1541();
		class_773 blockModelShapes = blockRendererDispatcher.method_3351();
		class_1087 blockModel = blockModelShapes.method_3335(blockState);
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		class_1058 textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
		if (textureAtlasSprite instanceof class_1047) {
			return null;
		}
		return textureAtlasSprite;
	}

	@Nullable
	private static class_1058 getTextureAtlasSprite(class_1799 itemStack) {
		class_918 itemRenderer = class_310.method_1551().method_1480();
		class_763 itemModelMesher = itemRenderer.method_4012();
		class_1087 itemModel = itemModelMesher.method_3308(itemStack);
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		class_1058 particleTexture = renderHelper.getParticleIcon(itemModel);
		if (particleTexture instanceof class_1047) {
			return null;
		}
		return particleTexture;
	}
}
