package mezz.jei.api.registration;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public interface IRecipeCatalystRegistration {
	/**
	 * The {@link IIngredientManager} has some useful functions related to recipe ingredients.
	 * @since 9.5.5
	 */
	IIngredientManager getIngredientManager();

	/**
	 * {@link IJeiHelpers} provides helpers and tools for addon mods.
	 * @since 10.2.0
	 */
	IJeiHelpers getJeiHelpers();

	/**
	 * Add an association between an {@link class_1799} and what it can craft.
	 * (i.e. Furnace ItemStack can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param ingredient  the {@link class_1799} that can craft recipes (like a furnace or crafting table)
	 * @param recipeTypes the types of recipe that the ingredient is a catalyst for
	 * @see #addRecipeCatalyst(IIngredientType, Object, RecipeType...) to add non-{@link class_1799} catalysts.
	 *
	 * @since 9.5.0
	 */
	default void addRecipeCatalyst(class_1799 ingredient, RecipeType<?>... recipeTypes) {
		addRecipeCatalyst(VanillaTypes.ITEM_STACK, ingredient, recipeTypes);
	}

	/**
	 * Add an association between an ingredient and what it can craft. (i.e. Furnace ItemStack -> Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param ingredientType the type of the ingredient
	 * @param ingredient     the ingredient that can craft recipes (like a furnace or crafting table)
	 * @param recipeTypes    the types of recipe that the ingredient is a catalyst for
	 * @since 9.5.0
	 */
	<T> void addRecipeCatalyst(IIngredientType<T> ingredientType, T ingredient, RecipeType<?>... recipeTypes);

	/**
	 * Add an association between an {@link class_1799} and what it can craft.
	 * (i.e. Furnace ItemStack can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param catalystIngredient the {@link class_1799} that can craft recipes (like a furnace or crafting table)
	 * @param recipeCategoryUids the recipe categories handled by the catalyst
	 * @see #addRecipeCatalyst(IIngredientType, Object, class_2960...) to add non-{@link class_1799} catalysts.
	 *
	 * @deprecated use {@link #addRecipeCatalyst(class_1799, RecipeType...)}
	 */
	@Deprecated(forRemoval = true, since = "9.5.0")
	default void addRecipeCatalyst(class_1799 catalystIngredient, class_2960... recipeCategoryUids) {
		addRecipeCatalyst(VanillaTypes.ITEM_STACK, catalystIngredient, recipeCategoryUids);
	}

	/**
	 * Add an association between an ingredient and what it can craft. (i.e. Furnace ItemStack -> Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param catalystIngredient the ingredient that can craft recipes (like a furnace or crafting table)
	 * @param recipeCategoryUids the recipe categories handled by the ingredient
	 *
	 * @deprecated use {@link #addRecipeCatalyst(IIngredientType, Object, RecipeType...)}
	 */
	@Deprecated(forRemoval = true, since = "9.5.0")
	<T> void addRecipeCatalyst(IIngredientType<T> ingredientType, T catalystIngredient, class_2960... recipeCategoryUids);
}
