package mezz.jei.api.recipe.vanilla;

import org.jetbrains.annotations.Unmodifiable;

import javax.annotation.Nonnegative;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import java.util.List;

/**
 * Fueling recipes represent items that can be used as fuel in the Furnace, Smoker, Blast Furnace, etc.
 *
 * JEI automatically creates a fueling recipe for anything that has a burn time.
 *
 * @see class_1792#getBurnTime
 *
 * @since 9.5.0
 */
public interface IJeiFuelingRecipe {
	/**
	 * @return the inputs that act as a fuel
	 */
	@Unmodifiable
	List<class_1799> getInputs();

	/**
	 * @return the fuel's burn time in ticks. Always greater than 0.
	 */
	@Nonnegative
	int getBurnTime();
}
