package mezz.jei.api.constants;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import mezz.jei.api.ingredients.IIngredientType;

/**
 * Built-in {@link IIngredientType} for vanilla Minecraft.
 */
public final class VanillaTypes {
	/**
	 * @since 9.7.0
	 */
	public static final IIngredientTypeWithSubtypes<class_1792, class_1799> ITEM_STACK = new IIngredientTypeWithSubtypes<>() {
		@Override
		public Class<? extends ItemStack> getIngredientClass() {
			return ItemStack.class;
		}

		@Override
		public Class<? extends Item> getIngredientBaseClass() {
			return Item.class;
		}

		@Override
		public Item getBase(ItemStack ingredient) {
			return ingredient.getItem();
		}
	};

	/**
	 * @deprecated use {@link #ITEM_STACK}
	 */
	@Deprecated(forRemoval = true, since = "9.7.0")
	public static final IIngredientType<class_1799> ITEM = ITEM_STACK;

	private VanillaTypes() {

	}
}
