package mezz.jei.api.constants;

import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3962;
import net.minecraft.class_3975;
import net.minecraft.class_5357;

/**
 * List of all the built-in {@link RecipeType}s that are added by JEI.
 *
 * @since 9.5.0
 */
public final class RecipeTypes {
	/**
	 * The crafting recipe type.
	 *
	 * Automatically includes all recipes in the {@link net.minecraft.class_1863}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_3955> CRAFTING =
		RecipeType.create(ModIds.MINECRAFT_ID, "crafting", class_3955.class);

	/**
	 * The stonecutting recipe type.
	 *
	 * Automatically includes every {@link class_3975}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_3975> STONECUTTING =
		RecipeType.create(ModIds.MINECRAFT_ID, "stonecutting", class_3975.class);

	/**
	 * The smelting recipe type.
	 *
	 * Automatically includes every {@link class_3861}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_3861> SMELTING =
		RecipeType.create(ModIds.MINECRAFT_ID, "furnace", class_3861.class);

	/**
	 * The smoking recipe type.
	 *
	 * Automatically includes every {@link class_3862}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_3862> SMOKING =
		RecipeType.create(ModIds.MINECRAFT_ID, "smoking", class_3862.class);

	/**
	 * The blasting recipe type.
	 *
	 * Automatically includes every {@link class_3859}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_3859> BLASTING =
		RecipeType.create(ModIds.MINECRAFT_ID, "blasting", class_3859.class);

	/**
	 * The campfire cooking recipe type.
	 *
	 * Automatically includes every {@link class_3920}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_3920> CAMPFIRE_COOKING =
		RecipeType.create(ModIds.MINECRAFT_ID, "campfire", class_3920.class);

	/**
	 * The fueling recipe type.
	 *
	 * JEI automatically creates a fuel recipe for anything that has a burn time.
	 * @see class_1792#getBurnTime
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiFuelingRecipe> FUELING =
		RecipeType.create(ModIds.MINECRAFT_ID, "fuel", IJeiFuelingRecipe.class);

	/**
	 * The brewing recipe type.
	 *
	 * JEI automatically tries to generate all potion variations from the basic ingredients,
	 * and also automatically adds modded potions from the Forge BrewingRecipeRegistry
	 *
	 * @see IVanillaRecipeFactory#createBrewingRecipe to create new brewing recipes in JEI.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiBrewingRecipe> BREWING =
		RecipeType.create(ModIds.MINECRAFT_ID, "brewing", IJeiBrewingRecipe.class);

	/**
	 * The anvil recipe type.
	 *
	 * @see IVanillaRecipeFactory#createAnvilRecipe to create new anvil recipes in JEI.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiAnvilRecipe> ANVIL =
		RecipeType.create(ModIds.MINECRAFT_ID, "anvil", IJeiAnvilRecipe.class);

	/**
	 * The smithing recipe type.
	 * Automatically includes every {@link class_5357}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<class_5357> SMITHING =
		RecipeType.create(ModIds.MINECRAFT_ID, "smithing", class_5357.class);

	/**
	 * The composting recipe type.
	 * Automatically includes every item added to {@link class_3962#field_17566}.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiCompostingRecipe> COMPOSTING =
		RecipeType.create(ModIds.MINECRAFT_ID, "compostable", IJeiCompostingRecipe.class);

	/**
	 * The JEI info recipe type.
	 *
	 * @see IRecipeRegistration#addIngredientInfo to create this type of recipe.
	 *
	 * @since 9.5.0
	 */
	public static final RecipeType<IJeiIngredientInfoRecipe> INFORMATION =
		RecipeType.create(ModIds.JEI_ID, "information", IJeiIngredientInfoRecipe.class);

	private RecipeTypes() {}
}
