/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IServerConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ServerCommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ServerCommandUtil() {
    }

    public static boolean hasPermissionForCheatMode(ServerPlayer sender, IServerConfig serverConfig) {
        CommandNode<CommandSourceStack> giveCommand;
        MinecraftServer minecraftServer;
        if (serverConfig.isCheatModeEnabledForCreative() && sender.isCreative()) {
            return true;
        }
        CommandSourceStack commandSource = sender.createCommandSourceStack();
        if (serverConfig.isCheatModeEnabledForOp() && (minecraftServer = sender.getServer()) != null) {
            int opPermissionLevel = minecraftServer.getOperatorUserPermissionLevel();
            return commandSource.hasPermission(opPermissionLevel);
        }
        if (serverConfig.isCheatModeEnabledForGive() && (giveCommand = ServerCommandUtil.getGiveCommand((Player)sender)) != null) {
            return giveCommand.canUse((Object)commandSource);
        }
        return false;
    }

    public static void executeGive(ServerPacketContext context, ItemStack itemStack, GiveMode giveMode) {
        IServerConfig serverConfig;
        ServerPlayer sender = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(sender, serverConfig = context.serverConfig())) {
            if (giveMode == GiveMode.INVENTORY) {
                ServerCommandUtil.giveToInventory((Player)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                ServerCommandUtil.mousePickupItemStack((Player)sender, itemStack);
            }
        } else {
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPacketContext context, ItemStack itemStack, int hotbarSlot) {
        IServerConfig serverConfig;
        ServerPlayer sender = context.player();
        if (ServerCommandUtil.hasPermissionForCheatMode(sender, serverConfig = context.serverConfig())) {
            if (!Inventory.isHotbarSlot((int)hotbarSlot)) {
                LOGGER.error("Tried to set slot that is not in the hotbar: {}", (Object)hotbarSlot);
                return;
            }
            ItemStack stackInSlot = sender.getInventory().getItem(hotbarSlot);
            if (ItemStack.matches((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            ItemStack itemStackCopy = itemStack.copy();
            sender.getInventory().setItem(hotbarSlot, itemStack);
            sender.level.playSound(null, sender.getX(), sender.getY(), sender.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((sender.getRandom().nextFloat() - sender.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.inventoryMenu.broadcastChanges();
            ServerCommandUtil.notifyGive((Player)sender, itemStackCopy);
        } else {
            IConnectionToClient connection = context.connection();
            connection.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(Player sender, ItemStack itemStack) {
        int giveCount;
        AbstractContainerMenu containerMenu = sender.containerMenu;
        ItemStack itemStackCopy = itemStack.copy();
        ItemStack existingStack = containerMenu.getCarried();
        if (ServerCommandUtil.canStack(existingStack, itemStack)) {
            int newCount = Math.min(existingStack.getMaxStackSize(), existingStack.getCount() + itemStack.getCount());
            giveCount = newCount - existingStack.getCount();
            existingStack.setCount(newCount);
        } else {
            containerMenu.setCarried(itemStack);
            giveCount = itemStack.getCount();
        }
        if (giveCount > 0) {
            itemStackCopy.setCount(giveCount);
            ServerCommandUtil.notifyGive(sender, itemStackCopy);
            containerMenu.broadcastChanges();
        }
    }

    private static boolean canStack(ItemStack a, ItemStack b) {
        return ItemStack.matches((ItemStack)a, (ItemStack)b);
    }

    private static void giveToInventory(Player entityplayermp, ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.copy();
        boolean flag = entityplayermp.getInventory().add(itemStack);
        if (flag && itemStack.isEmpty()) {
            itemStack.setCount(1);
            ItemEntity entityitem = entityplayermp.drop(itemStack, false);
            if (entityitem != null) {
                entityitem.makeFakeItem();
            }
            entityplayermp.level.playSound(null, entityplayermp.getX(), entityplayermp.getY(), entityplayermp.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((entityplayermp.getRandom().nextFloat() - entityplayermp.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity entityitem = entityplayermp.drop(itemStack, false);
            if (entityitem != null) {
                entityitem.setNoPickUpDelay();
                entityitem.setOwner(entityplayermp.getUUID());
            }
        }
        ServerCommandUtil.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(Player player, ItemStack stack) {
        if (player.getServer() == null) {
            return;
        }
        CommandSourceStack commandSource = player.createCommandSourceStack();
        int count = stack.getCount();
        Component stackTextComponent = stack.getDisplayName();
        Component displayName = player.getDisplayName();
        MutableComponent message = Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{count, stackTextComponent, displayName});
        commandSource.sendSuccess((Component)message, true);
    }

    @Nullable
    private static CommandNode<CommandSourceStack> getGiveCommand(Player sender) {
        MinecraftServer minecraftServer = sender.getServer();
        if (minecraftServer == null) {
            return null;
        }
        Commands commandManager = minecraftServer.getCommands();
        CommandDispatcher dispatcher = commandManager.getDispatcher();
        RootCommandNode root = dispatcher.getRoot();
        return root.getChild("give");
    }
}

