/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import mezz.jei.common.gui.HoverChecker;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.handlers.TextFieldInputHandler;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.TextHistory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class GuiTextFieldFilter
extends EditBox {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final HoverChecker hoverChecker;
    private final DrawableNineSliceTexture background;
    private ImmutableRect2i backgroundBounds;
    private boolean previousKeyboardRepeatEnabled;
    @Nullable
    private AbstractWidget previouslyFocusedWidget;

    public GuiTextFieldFilter(Textures textures) {
        super(Minecraft.getInstance().font, 0, 0, 0, 0, CommonComponents.EMPTY);
        this.setMaxLength(128);
        this.hoverChecker = new HoverChecker();
        this.background = textures.getSearchBackground();
        this.backgroundBounds = ImmutableRect2i.EMPTY;
        this.setBordered(false);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.backgroundBounds = area;
        this.x = area.getX() + 4;
        this.y = area.getY() + (area.getHeight() - 8) / 2;
        this.width = area.getWidth() - 12;
        this.height = area.getHeight();
        this.hoverChecker.updateBounds(area);
    }

    public void setValue(String filterText) {
        if (!filterText.equals(this.getValue())) {
            super.setValue(filterText);
        }
    }

    public Optional<String> getHistory(TextHistory.Direction direction) {
        String currentText = this.getValue();
        return history.get(direction, currentText);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new TextFieldInputHandler(this);
    }

    public void setFocused(boolean keyboardFocus) {
        boolean previousFocus = this.isFocused();
        super.setFocused(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.getInstance();
            if (keyboardFocus) {
                IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
                this.previousKeyboardRepeatEnabled = inputHelper.isSendRepeatsToGui(minecraft.keyboardHandler);
                minecraft.keyboardHandler.setSendRepeatsToGui(true);
                Screen screen = minecraft.screen;
                if (screen != null) {
                    GuiEventListener guiEventListener = screen.getFocused();
                    if (guiEventListener instanceof AbstractWidget) {
                        AbstractWidget widget = (AbstractWidget)guiEventListener;
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(widget, false);
                        this.previouslyFocusedWidget = widget;
                    }
                    screen.setFocused(null);
                }
            } else {
                if (this.previouslyFocusedWidget != null) {
                    Screen screen = minecraft.screen;
                    if (screen != null) {
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(this.previouslyFocusedWidget, true);
                        screen.setFocused((GuiEventListener)this.previouslyFocusedWidget);
                    }
                    this.previouslyFocusedWidget = null;
                }
                minecraft.keyboardHandler.setSendRepeatsToGui(this.previousKeyboardRepeatEnabled);
            }
            String text = this.getValue();
            history.add(text);
        }
    }

    public void renderButton(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.backgroundBounds);
        }
        super.renderButton(poseStack, mouseX, mouseY, partialTicks);
    }
}

