/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.util.ExpandNewLineTextAcceptor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class StringUtil {
    private StringUtil() {
    }

    public static Component stripStyling(Component textComponent) {
        MutableComponent text = textComponent.plainCopy();
        for (Component sibling : textComponent.getSiblings()) {
            text.append(StringUtil.stripStyling(sibling));
        }
        return text;
    }

    public static Component truncateStringToWidth(Component text, int width, Font fontRenderer) {
        int ellipsisWidth = fontRenderer.width("...");
        FormattedText truncatedText = fontRenderer.substrByWidth((FormattedText)text, width - ellipsisWidth);
        String truncatedTextString = truncatedText.getString();
        return Component.literal((String)(truncatedTextString + "..."));
    }

    public static List<FormattedText> splitLines(List<FormattedText> lines, int width) {
        if (width <= 0) {
            return List.copyOf(lines);
        }
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        StringSplitter splitter = font.getSplitter();
        return lines.stream().flatMap(text -> splitter.splitLines(text, width, Style.EMPTY).stream()).toList();
    }

    public static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.visit((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.EMPTY);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    public static String intsToString(Collection<Integer> indexes) {
        return indexes.stream().sorted().map(i -> Integer.toString(i)).collect(Collectors.joining(", "));
    }
}

