/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.crafting;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.Nullable;

public class CraftingCategoryExtension<T extends CraftingRecipe>
implements ICraftingCategoryExtension {
    protected final T recipe;

    public CraftingCategoryExtension(T recipe) {
        this.recipe = recipe;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        List<List> inputs = this.recipe.getIngredients().stream().map(ingredient -> List.of(ingredient.getItems())).toList();
        ItemStack resultItem = this.recipe.getResultItem();
        int width = this.getWidth();
        int height = this.getHeight();
        craftingGridHelper.createAndSetOutputs(builder, List.of(resultItem));
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.getId();
    }

    public int getWidth() {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        return recipeHelper.getWidth(this.recipe);
    }

    public int getHeight() {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        return recipeHelper.getHeight(this.recipe);
    }
}

