/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes.layout;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.ingredients.RecipeSlot;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.recipes.OutputSlotTooltipCallback;
import mezz.jei.common.gui.recipes.ShapelessIcon;
import mezz.jei.common.gui.recipes.layout.IRecipeLayoutInternal;
import mezz.jei.common.gui.recipes.layout.RecipeLayoutBuilder;
import mezz.jei.common.gui.recipes.layout.RecipeTransferButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RecipeLayout<R>
implements IRecipeLayoutInternal<R>,
IRecipeLayoutDrawable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int RECIPE_BORDER_PADDING = 4;
    private final int ingredientCycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
    private final IRecipeCategory<R> recipeCategory;
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientVisibility ingredientVisibility;
    private final IModIdHelper modIdHelper;
    private final Textures textures;
    private final RecipeSlots recipeSlots;
    private final R recipe;
    private final DrawableNineSliceTexture recipeBorder;
    @Nullable
    private final RecipeTransferButton recipeTransferButton;
    @Nullable
    private ShapelessIcon shapelessIcon;
    private int posX;
    private int posY;

    @Nullable
    public static <T> RecipeLayout<T> create(int index, IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focuses, RegisteredIngredients registeredIngredients, IIngredientVisibility ingredientVisibility, IModIdHelper modIdHelper, int posX, int posY, Textures textures) {
        RecipeLayout<T> recipeLayout = new RecipeLayout<T>(index, recipeCategory, recipe, registeredIngredients, ingredientVisibility, modIdHelper, posX, posY, textures);
        if (recipeLayout.setRecipeLayout(recipeCategory, recipe, focuses)) {
            ResourceLocation recipeName = recipeCategory.getRegistryName(recipe);
            if (recipeName != null) {
                RecipeLayout.addOutputSlotTooltip(recipeLayout, recipeName, modIdHelper);
            }
            return recipeLayout;
        }
        return null;
    }

    private boolean setRecipeLayout(IRecipeCategory<R> recipeCategory, R recipe, IFocusGroup focuses) {
        RecipeLayoutBuilder builder = new RecipeLayoutBuilder(this.registeredIngredients, this.ingredientVisibility, this.ingredientCycleOffset);
        try {
            recipeCategory.setRecipe((IRecipeLayoutBuilder)builder, recipe, focuses);
            if (builder.isUsed()) {
                builder.setRecipeLayout(this, focuses);
                return true;
            }
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", (Object)recipeCategory.getRecipeType().getUid(), (Object)e);
        }
        return false;
    }

    private static void addOutputSlotTooltip(RecipeLayout<?> recipeLayout, ResourceLocation recipeName, IModIdHelper modIdHelper) {
        RecipeSlots recipeSlots = recipeLayout.recipeSlots;
        List<RecipeSlot> outputSlots = recipeSlots.getSlots().stream().filter(r -> r.getRole() == RecipeIngredientRole.OUTPUT).toList();
        if (!outputSlots.isEmpty()) {
            OutputSlotTooltipCallback callback = new OutputSlotTooltipCallback(recipeName, modIdHelper, recipeLayout.registeredIngredients);
            for (RecipeSlot outputSlot : outputSlots) {
                outputSlot.addTooltipCallback(callback);
            }
        }
    }

    public RecipeLayout(int index, IRecipeCategory<R> recipeCategory, R recipe, RegisteredIngredients registeredIngredients, IIngredientVisibility ingredientVisibility, IModIdHelper modIdHelper, int posX, int posY, Textures textures) {
        this.recipeCategory = recipeCategory;
        this.registeredIngredients = registeredIngredients;
        this.ingredientVisibility = ingredientVisibility;
        this.modIdHelper = modIdHelper;
        this.textures = textures;
        this.recipeSlots = new RecipeSlots();
        if (index >= 0) {
            IDrawableStatic icon = textures.getRecipeTransfer();
            IDrawable background = recipeCategory.getBackground();
            int width = background.getWidth();
            int height = background.getHeight();
            int buttonX = width + 4 + 2;
            int buttonY = height - 13;
            this.recipeTransferButton = new RecipeTransferButton(buttonX, buttonY, (IDrawable)icon, this, textures);
        } else {
            this.recipeTransferButton = null;
        }
        this.setPosition(posX, posY);
        this.recipe = recipe;
        this.recipeBorder = textures.getRecipeBackground();
    }

    @Override
    public void setPosition(int posX, int posY) {
        if (this.recipeTransferButton != null) {
            int xDiff = posX - this.posX;
            int yDiff = posY - this.posY;
            this.recipeTransferButton.x += xDiff;
            this.recipeTransferButton.y += yDiff;
        }
        this.posX = posX;
        this.posY = posY;
    }

    @Override
    public void drawRecipe(PoseStack poseStack, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        poseStack.pushPose();
        poseStack.translate((double)this.posX, (double)this.posY, 0.0);
        IDrawable categoryBackground = this.recipeCategory.getBackground();
        int width = categoryBackground.getWidth() + 8;
        int height = categoryBackground.getHeight() + 8;
        this.recipeBorder.draw(poseStack, -4, -4, width, height);
        background.draw(poseStack);
        poseStack.pushPose();
        this.recipeCategory.draw(this.recipe, this.recipeSlots.getView(), poseStack, (double)recipeMouseX, (double)recipeMouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(poseStack);
        }
        this.recipeSlots.draw(poseStack);
        poseStack.popPose();
        if (this.recipeTransferButton != null) {
            Minecraft minecraft = Minecraft.getInstance();
            float partialTicks = minecraft.getFrameTime();
            this.recipeTransferButton.render(poseStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
    }

    @Override
    public void drawOverlays(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        RecipeSlot hoveredSlot = this.recipeSlots.getHoveredSlot(recipeMouseX, recipeMouseY).orElse(null);
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.drawToolTip(poseStack, mouseX, mouseY);
        }
        RenderSystem.disableBlend();
        if (hoveredSlot != null) {
            hoveredSlot.drawOverlays(poseStack, this.posX, this.posY, recipeMouseX, recipeMouseY, this.modIdHelper);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            List<Component> tooltipStrings = this.recipeCategory.getTooltipStrings(this.recipe, this.recipeSlots.getView(), (double)recipeMouseX, (double)recipeMouseY);
            if (tooltipStrings.isEmpty() && this.shapelessIcon != null) {
                tooltipStrings = this.shapelessIcon.getTooltipStrings(recipeMouseX, recipeMouseY);
            }
            if (tooltipStrings != null && !tooltipStrings.isEmpty()) {
                TooltipRenderer.drawHoveringText(poseStack, tooltipStrings, mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        ImmutableRect2i backgroundRect = new ImmutableRect2i(this.posX, this.posY, background.getWidth(), background.getHeight());
        return backgroundRect.contains(mouseX, mouseY) || this.recipeTransferButton != null && this.recipeTransferButton.isMouseOver(mouseX, mouseY);
    }

    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return this.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(slot -> slot.getDisplayedIngredient(ingredientType));
    }

    @Override
    public Optional<RecipeSlot> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        double recipeMouseX = mouseX - (double)this.posX;
        double recipeMouseY = mouseY - (double)this.posY;
        return this.recipeSlots.getHoveredSlot(recipeMouseX, recipeMouseY);
    }

    public boolean handleInput(UserInput input, IInternalKeyMappings keyBindings) {
        double recipeMouseY;
        if (!this.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return false;
        }
        double recipeMouseX = input.getMouseX() - (double)this.posX;
        if (this.recipeCategory.handleInput(this.recipe, recipeMouseX, recipeMouseY = input.getMouseY() - (double)this.posY, input.getKey())) {
            return true;
        }
        if (input.is(keyBindings.getCopyRecipeId())) {
            return this.handleCopyRecipeId();
        }
        return false;
    }

    private boolean handleCopyRecipeId() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        ResourceLocation registryName = this.recipeCategory.getRegistryName(this.recipe);
        if (registryName == null) {
            MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.failure");
            if (player != null) {
                player.displayClientMessage((Component)message, false);
            }
            return false;
        }
        String recipeId = registryName.toString();
        minecraft.keyboardHandler.setClipboard(recipeId);
        MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{recipeId});
        if (player != null) {
            player.displayClientMessage((Component)message, false);
        }
        return true;
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.x = posX + this.posX;
            this.recipeTransferButton.y = posY + this.posY;
        }
    }

    @Override
    public void setShapeless() {
        this.shapelessIcon = new ShapelessIcon(this.textures);
        int categoryWidth = this.recipeCategory.getBackground().getWidth();
        int x = categoryWidth - this.shapelessIcon.getIcon().getWidth();
        int y = 0;
        this.shapelessIcon.setPosition(x, y);
    }

    public void setShapeless(int shapelessX, int shapelessY) {
        this.shapelessIcon = new ShapelessIcon(this.textures);
        this.shapelessIcon.setPosition(shapelessX, shapelessY);
    }

    @Nullable
    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    @Override
    public RecipeSlots getRecipeSlots() {
        return this.recipeSlots;
    }
}

