/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;

public class OffsetDrawable
implements IDrawable {
    private final IDrawable drawable;
    private final int xOffset;
    private final int yOffset;

    public static IDrawable create(IDrawable drawable, int xOffset, int yOffset) {
        if (xOffset == 0 && yOffset == 0) {
            return drawable;
        }
        return new OffsetDrawable(drawable, xOffset, yOffset);
    }

    private OffsetDrawable(IDrawable drawable, int xOffset, int yOffset) {
        this.drawable = drawable;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getWidth() {
        return this.drawable.getWidth();
    }

    public int getHeight() {
        return this.drawable.getHeight();
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        this.drawable.draw(poseStack, this.xOffset + xOffset, this.yOffset + yOffset);
    }

    public void draw(PoseStack poseStack) {
        this.drawable.draw(poseStack, this.xOffset, this.yOffset);
    }
}

