/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.render;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientRenderHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <V> List<Component> getIngredientTooltipSafe(V ingredient, IIngredientRenderer<V> ingredientRenderer, IIngredientHelper<V> ingredientHelper, IModIdHelper modIdHelper) {
        try {
            Minecraft minecraft = Minecraft.getInstance();
            TooltipFlag.Default tooltipFlag = minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            List tooltip = ingredientRenderer.getTooltip(ingredient, (TooltipFlag)tooltipFlag);
            tooltip = modIdHelper.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
            return tooltip;
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Tooltip crashed.", e);
            ArrayList<Component> tooltip = new ArrayList<Component>();
            TranslatableComponent translated = new TranslatableComponent("jei.tooltip.error.crash");
            tooltip.add((Component)translated.withStyle(ChatFormatting.RED));
            return tooltip;
        }
    }
}

