/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients;

import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.config.IEditModeConfig;
import mezz.jei.common.ingredients.IngredientBlacklistInternal;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.core.config.IWorldConfig;

public class IngredientVisibility
implements IIngredientVisibility {
    private final IngredientBlacklistInternal blacklist;
    private final IWorldConfig worldConfig;
    private final IEditModeConfig editModeConfig;
    private final RegisteredIngredients registeredIngredients;

    public IngredientVisibility(IngredientBlacklistInternal blacklist, IWorldConfig worldConfig, IEditModeConfig editModeConfig, RegisteredIngredients registeredIngredients) {
        this.blacklist = blacklist;
        this.worldConfig = worldConfig;
        this.editModeConfig = editModeConfig;
        this.registeredIngredients = registeredIngredients;
    }

    public <V> boolean isIngredientVisible(ITypedIngredient<V> typedIngredient) {
        IIngredientType ingredientType = typedIngredient.getType();
        IIngredientHelper ingredientHelper = this.registeredIngredients.getIngredientHelper(ingredientType);
        return this.isIngredientVisible(typedIngredient, ingredientHelper);
    }

    public <V> boolean isIngredientVisible(IIngredientType<V> ingredientType, V ingredient) {
        IIngredientHelper ingredientHelper = this.registeredIngredients.getIngredientHelper(ingredientType);
        return TypedIngredient.createTyped(this.registeredIngredients, ingredientType, ingredient).map(i -> this.isIngredientVisible((ITypedIngredient)i, ingredientHelper)).orElse(false);
    }

    public <V> boolean isIngredientVisible(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        if (this.blacklist.isIngredientBlacklistedByApi(typedIngredient, ingredientHelper)) {
            return false;
        }
        if (!ingredientHelper.isIngredientOnServer(typedIngredient.getIngredient())) {
            return false;
        }
        return this.worldConfig.isEditModeEnabled() || !this.editModeConfig.isIngredientOnConfigBlacklist(typedIngredient, ingredientHelper);
    }
}

