/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.GuiIconToggleButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ConfigButton
extends GuiIconToggleButton {
    private final IKeyBindings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IKeyBindings keyBindings) {
        return new ConfigButton((IDrawable)textures.getConfigButtonIcon(), (IDrawable)textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, textures, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IKeyBindings keyBindings) {
        super(disabledIcon, enabledIcon, textures);
        this.isListDisplayed = isListDisplayed;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            TranslatableComponent disabled = new TranslatableComponent("jei.tooltip.ingredient.list.disabled");
            TranslatableComponent disabledFix = new TranslatableComponent("jei.tooltip.ingredient.list.disabled.how.to.fix", new Object[]{this.keyBindings.getToggleOverlay().getTranslatedKeyMessage()});
            tooltip.add((Component)disabled.withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)disabledFix.withStyle(ChatFormatting.GOLD));
        } else if (!this.isListDisplayed.getAsBoolean()) {
            TranslatableComponent notEnoughSpace = new TranslatableComponent("jei.tooltip.not.enough.space");
            tooltip.add((Component)notEnoughSpace.withStyle(ChatFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            MutableComponent enabled = new TranslatableComponent("jei.tooltip.cheat.mode.button.enabled").withStyle(ChatFormatting.RED);
            tooltip.add((Component)enabled);
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                component = new TranslatableComponent("jei.tooltip.cheat.mode.how.to.disable.hotkey", new Object[]{this.keyBindings.getToggleCheatMode().getTranslatedKeyMessage()}).withStyle(ChatFormatting.RED);
                tooltip.add((Component)component);
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                component = new TranslatableComponent("jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", new Object[]{this.keyBindings.getToggleCheatModeConfigButton().getTranslatedKeyMessage()}).withStyle(ChatFormatting.RED);
                tooltip.add((Component)component);
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.worldConfig.toggleCheatItemsEnabled();
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional<Screen> configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.setScreen(configScreen.get());
        } else {
            Component message = configHelper.getMissingConfigScreenMessage();
            mc.player.displayClientMessage(message, false);
        }
    }
}

