/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.util;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class PathUtil {
    private static final String unsafeFileChars = "[^\\w-]";
    private static boolean atomicMoveSupported = true;

    public static String sanitizePathName(String filename) {
        return String.join((CharSequence)"_", filename.split(unsafeFileChars));
    }

    public static boolean migrateConfigLocation(Path newFile, Path oldFile) throws IOException {
        if (Files.exists(newFile, new LinkOption[0]) || !Files.exists(oldFile, new LinkOption[0])) {
            return false;
        }
        PathUtil.moveAtomicReplace(oldFile, newFile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path writeUsingTempFile(Path path, Iterable<? extends CharSequence> lines) throws IOException {
        Path tempFile = Files.createTempFile(path.getParent(), null, null, new FileAttribute[0]);
        try {
            Files.write(tempFile, lines, new OpenOption[0]);
            Path path2 = PathUtil.moveAtomicReplace(tempFile, path);
            return path2;
        }
        finally {
            if (Files.exists(tempFile, new LinkOption[0])) {
                Files.delete(tempFile);
            }
        }
    }

    private static Path moveAtomicReplace(Path source, Path target) throws IOException {
        if (atomicMoveSupported) {
            try {
                return Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException ignored) {
                atomicMoveSupported = false;
            }
        }
        return Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
    }
}

